/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Optional;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.messages.model.MessageDirection;

public interface MessagePath
extends JsonPointer {
    public Optional<String> getFeatureId();

    public Optional<MessageDirection> getDirection();

    public Optional<String> getMessageSubject();

    default public boolean isInboxOutboxMessage() {
        return this.getDirection().isPresent();
    }

    public static Optional<MessageDirection> jsonKeyToDirection(JsonKey jsonKey) {
        switch (jsonKey.toString()) {
            case "inbox": {
                return Optional.of(MessageDirection.TO);
            }
            case "outbox": {
                return Optional.of(MessageDirection.FROM);
            }
        }
        return Optional.empty();
    }

    public static JsonKey directionToJsonKey(MessageDirection direction) {
        return JsonKey.of((CharSequence)(direction == MessageDirection.TO ? "inbox" : "outbox"));
    }
}

