/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.AcknowledgementTopicPathBuilder;
import org.eclipse.ditto.protocol.AnnouncementsTopicPathBuilder;
import org.eclipse.ditto.protocol.CommandsTopicPathBuilder;
import org.eclipse.ditto.protocol.EventsTopicPathBuilder;
import org.eclipse.ditto.protocol.MessagesTopicPathBuilder;
import org.eclipse.ditto.protocol.SearchTopicPathBuilder;
import org.eclipse.ditto.protocol.StreamingTopicPathBuilder;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuildable;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandException;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;

@Immutable
final class ImmutableTopicPath
implements TopicPath {
    private final String namespace;
    private final String name;
    private final TopicPath.Group group;
    private final TopicPath.Channel channel;
    private final TopicPath.Criterion criterion;
    @Nullable
    private final TopicPath.Action action;
    @Nullable
    private final TopicPath.SearchAction searchAction;
    @Nullable
    private final TopicPath.StreamingAction streamingAction;
    @Nullable
    private final String subject;

    private ImmutableTopicPath(Builder builder) {
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.group = builder.group;
        this.channel = builder.channel;
        this.criterion = builder.criterion;
        this.action = builder.action;
        this.searchAction = builder.searchAction;
        this.streamingAction = builder.streamingAction;
        this.subject = builder.subject;
    }

    static TopicPathBuilder newBuilder(String namespace, String entityName) {
        ConditionChecker.checkNotNull((Object)namespace, (String)"namespace");
        ConditionChecker.checkNotNull((Object)entityName, (String)"entityName");
        return new Builder(namespace, entityName);
    }

    static ImmutableTopicPath parseTopicPath(String topicPathString) {
        TopicPathParser topicPathParser = new TopicPathParser((String)ConditionChecker.checkNotNull((Object)topicPathString, (String)"topicPathString"));
        return topicPathParser.get();
    }

    static JsonPointer newTopicOrPathPointer(String path) {
        String slash = "/";
        if (path.isEmpty() || "/".equals(path)) {
            return JsonPointer.empty();
        }
        ArrayList<JsonKey> jsonKeys = new ArrayList<JsonKey>();
        int segmentStart = path.startsWith("/") ? 1 : 0;
        int segmentEnd = path.indexOf("/", segmentStart);
        while (segmentEnd >= 0 && segmentStart != segmentEnd) {
            jsonKeys.add(JsonKey.of((CharSequence)path.substring(segmentStart, segmentEnd)));
            segmentStart = segmentEnd + 1;
            segmentEnd = path.indexOf("/", segmentStart);
        }
        if (segmentStart < path.length()) {
            jsonKeys.add(JsonKey.of((CharSequence)path.substring(segmentStart)));
        }
        return JsonFactory.newPointer((JsonKey)((JsonKey)jsonKeys.get(0)), (JsonKey[])((JsonKey[])jsonKeys.stream().skip(1L).toArray(JsonKey[]::new)));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public TopicPath.Group getGroup() {
        return this.group;
    }

    @Override
    public TopicPath.Channel getChannel() {
        return this.channel;
    }

    @Override
    public TopicPath.Criterion getCriterion() {
        return this.criterion;
    }

    @Override
    public Optional<TopicPath.Action> getAction() {
        return Optional.ofNullable(this.action);
    }

    @Override
    public Optional<TopicPath.SearchAction> getSearchAction() {
        return Optional.ofNullable(this.searchAction);
    }

    @Override
    public Optional<TopicPath.StreamingAction> getStreamingAction() {
        return Optional.ofNullable(this.streamingAction);
    }

    @Override
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    @Override
    public String getEntityName() {
        return this.name;
    }

    @Override
    public String getPath() {
        Stream<Object> pathPartStream = Stream.builder().add(this.namespace).add(this.name).add(this.group.getName()).add(TopicPath.Channel.NONE != this.channel ? this.channel.getName() : null).add(this.criterion.getName()).add(ImmutableTopicPath.getStringOrNull((Object)this.action)).add(ImmutableTopicPath.getStringOrNull((Object)this.searchAction)).add(ImmutableTopicPath.getStringOrNull((Object)this.streamingAction)).add(ImmutableTopicPath.getStringOrNull(this.subject)).build();
        return pathPartStream.filter(Objects::nonNull).collect(Collectors.joining("/"));
    }

    @Nullable
    private static String getStringOrNull(@Nullable Object pathPart) {
        String result = null == pathPart ? null : pathPart.toString();
        return result;
    }

    @Override
    public boolean isGroup(@Nullable TopicPath.Group expectedGroup) {
        return this.group.equals((Object)expectedGroup);
    }

    @Override
    public boolean isChannel(@Nullable TopicPath.Channel expectedChannel) {
        return this.channel.equals((Object)expectedChannel);
    }

    @Override
    public boolean isCriterion(@Nullable TopicPath.Criterion expectedCriterion) {
        return this.criterion.equals((Object)expectedCriterion);
    }

    @Override
    public boolean isAction(@Nullable TopicPath.Action expectedAction) {
        return Objects.equals((Object)this.action, (Object)expectedAction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTopicPath that = (ImmutableTopicPath)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && this.group == that.group && this.channel == that.channel && this.criterion == that.criterion && Objects.equals((Object)this.action, (Object)that.action) && Objects.equals((Object)this.searchAction, (Object)that.searchAction) && Objects.equals((Object)this.streamingAction, (Object)that.streamingAction) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.name, this.group, this.channel, this.criterion, this.action, this.searchAction, this.streamingAction, this.subject});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [namespace=" + this.namespace + ", name=" + this.name + ", group=" + (Object)((Object)this.group) + ", channel=" + (Object)((Object)this.channel) + ", criterion=" + (Object)((Object)this.criterion) + ", action=" + (Object)((Object)this.action) + ", searchAction=" + (Object)((Object)this.searchAction) + ", streamingAction=" + (Object)((Object)this.streamingAction) + ", subject=" + this.subject + ", path=" + this.getPath() + "]";
    }

    @NotThreadSafe
    private static final class Builder
    implements TopicPathBuilder,
    MessagesTopicPathBuilder,
    EventsTopicPathBuilder,
    CommandsTopicPathBuilder,
    AcknowledgementTopicPathBuilder,
    SearchTopicPathBuilder,
    AnnouncementsTopicPathBuilder,
    StreamingTopicPathBuilder {
        private final String namespace;
        private final String name;
        private TopicPath.Group group;
        private TopicPath.Channel channel;
        private TopicPath.Criterion criterion;
        @Nullable
        private TopicPath.Action action;
        @Nullable
        private TopicPath.SearchAction searchAction;
        @Nullable
        private TopicPath.StreamingAction streamingAction;
        @Nullable
        private String subject;

        private Builder(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.group = null;
            this.channel = TopicPath.Channel.NONE;
            this.criterion = null;
            this.action = null;
            this.searchAction = null;
            this.streamingAction = null;
            this.subject = null;
        }

        @Override
        public TopicPathBuilder things() {
            this.group = TopicPath.Group.THINGS;
            return this;
        }

        @Override
        public TopicPathBuilder policies() {
            this.group = TopicPath.Group.POLICIES;
            return this;
        }

        @Override
        public TopicPathBuilder connections() {
            this.group = TopicPath.Group.CONNECTIONS;
            return this;
        }

        @Override
        public TopicPathBuilder twin() {
            this.channel = TopicPath.Channel.TWIN;
            return this;
        }

        @Override
        public TopicPathBuilder live() {
            this.channel = TopicPath.Channel.LIVE;
            return this;
        }

        @Override
        public TopicPathBuilder none() {
            this.channel = TopicPath.Channel.NONE;
            return this;
        }

        @Override
        public SearchTopicPathBuilder search() {
            this.criterion = TopicPath.Criterion.SEARCH;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder commands() {
            this.criterion = TopicPath.Criterion.COMMANDS;
            return this;
        }

        @Override
        public AnnouncementsTopicPathBuilder announcements() {
            this.criterion = TopicPath.Criterion.ANNOUNCEMENTS;
            return this;
        }

        @Override
        public StreamingTopicPathBuilder streaming() {
            this.criterion = TopicPath.Criterion.STREAMING;
            return this;
        }

        @Override
        public EventsTopicPathBuilder events() {
            this.criterion = TopicPath.Criterion.EVENTS;
            return this;
        }

        @Override
        public TopicPathBuildable errors() {
            this.criterion = TopicPath.Criterion.ERRORS;
            return this;
        }

        @Override
        public MessagesTopicPathBuilder messages() {
            this.criterion = TopicPath.Criterion.MESSAGES;
            return this;
        }

        @Override
        public AcknowledgementTopicPathBuilder acks() {
            this.criterion = TopicPath.Criterion.ACKS;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder create() {
            this.action = TopicPath.Action.CREATE;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder retrieve() {
            this.action = TopicPath.Action.RETRIEVE;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder modify() {
            this.action = TopicPath.Action.MODIFY;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder merge() {
            this.action = TopicPath.Action.MERGE;
            return this;
        }

        @Override
        public CommandsTopicPathBuilder delete() {
            this.action = TopicPath.Action.DELETE;
            return this;
        }

        @Override
        public TopicPathBuildable subscribe() {
            this.searchAction = TopicPath.SearchAction.SUBSCRIBE;
            return this;
        }

        @Override
        public TopicPathBuildable subscribe(String subscribingCommandName) {
            if (!subscribingCommandName.equals("subscribeForPersistedEvents")) {
                throw (UnknownCommandException)UnknownCommandException.newBuilder(subscribingCommandName).build();
            }
            this.streamingAction = TopicPath.StreamingAction.SUBSCRIBE_FOR_PERSISTED_EVENTS;
            return this;
        }

        @Override
        public TopicPathBuildable cancel() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.CANCEL;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.CANCEL;
            }
            return this;
        }

        @Override
        public TopicPathBuildable request() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.REQUEST;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.REQUEST;
            }
            return this;
        }

        @Override
        public TopicPathBuildable complete() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.COMPLETE;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.COMPLETE;
            }
            return this;
        }

        @Override
        public TopicPathBuildable failed() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.FAILED;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.FAILED;
            }
            return this;
        }

        @Override
        public TopicPathBuildable hasNext() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.NEXT;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.NEXT;
            }
            return this;
        }

        @Override
        public EventsTopicPathBuilder generated() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.GENERATED;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.GENERATED;
            }
            return this;
        }

        @Override
        public TopicPathBuildable error() {
            if (this.criterion == TopicPath.Criterion.SEARCH) {
                this.searchAction = TopicPath.SearchAction.ERROR;
            } else if (this.criterion == TopicPath.Criterion.STREAMING) {
                this.streamingAction = TopicPath.StreamingAction.ERROR;
            }
            return this;
        }

        @Override
        public EventsTopicPathBuilder created() {
            this.action = TopicPath.Action.CREATED;
            return this;
        }

        @Override
        public EventsTopicPathBuilder modified() {
            this.action = TopicPath.Action.MODIFIED;
            return this;
        }

        @Override
        public EventsTopicPathBuilder merged() {
            this.action = TopicPath.Action.MERGED;
            return this;
        }

        @Override
        public EventsTopicPathBuilder deleted() {
            this.action = TopicPath.Action.DELETED;
            return this;
        }

        @Override
        public MessagesTopicPathBuilder subject(String subject) {
            this.subject = (String)ConditionChecker.checkNotNull((Object)subject, (String)"subject");
            return this;
        }

        @Override
        public AnnouncementsTopicPathBuilder name(String name) {
            this.subject = (String)ConditionChecker.checkNotNull((Object)name, (String)"name");
            return this;
        }

        @Override
        public AcknowledgementTopicPathBuilder label(CharSequence label) {
            this.subject = ((CharSequence)ConditionChecker.checkNotNull((Object)label, (String)"label")).toString();
            return this;
        }

        @Override
        public AcknowledgementTopicPathBuilder aggregatedAcks() {
            this.subject = null;
            return this;
        }

        @Override
        public ImmutableTopicPath build() {
            this.validateChannel();
            return new ImmutableTopicPath(this);
        }

        private void validateChannel() {
            if ((TopicPath.Group.POLICIES == this.group || TopicPath.Group.CONNECTIONS == this.group) && TopicPath.Channel.NONE != this.channel) {
                throw new IllegalStateException("The policies and connection groups require no channel.");
            }
        }
    }

    @NotThreadSafe
    private static final class TopicPathParser
    implements Supplier<ImmutableTopicPath> {
        private final String topicPathString;
        private final LinkedList<String> topicPathParts;

        private TopicPathParser(String topicPathString) {
            this.topicPathString = topicPathString;
            this.topicPathParts = TopicPathParser.splitByPathDelimiter(topicPathString);
        }

        private static LinkedList<String> splitByPathDelimiter(String topicPathString) {
            LinkedList result = StreamSupport.stream(ImmutableTopicPath.newTopicOrPathPointer(topicPathString).spliterator(), false).map(CharSequence::toString).collect(Collectors.toCollection(LinkedList::new));
            if (topicPathString.startsWith("/")) {
                result.addFirst("");
            }
            return result;
        }

        @Override
        public ImmutableTopicPath get() {
            Builder topicPathBuilder = new Builder(this.tryToGetNamespace(), this.tryToGetEntityName());
            topicPathBuilder.group = this.tryToGetGroup(this.tryToGetGroupName());
            topicPathBuilder.channel = this.tryToGetChannelForGroup(topicPathBuilder.group);
            topicPathBuilder.criterion = this.tryToGetCriterion(this.tryToGetCriterionName());
            switch (topicPathBuilder.criterion) {
                case COMMANDS: 
                case EVENTS: {
                    topicPathBuilder.action = this.tryToGetActionForName(this.tryToGetActionName());
                    break;
                }
                case SEARCH: {
                    topicPathBuilder.searchAction = this.tryToGetSearchActionForName(this.tryToGetSearchActionName());
                    break;
                }
                case STREAMING: {
                    topicPathBuilder.streamingAction = this.tryToGetStreamingActionForName(this.tryToGetSearchActionName());
                    break;
                }
                case ERRORS: {
                    break;
                }
                case MESSAGES: 
                case ACKS: 
                case ANNOUNCEMENTS: {
                    topicPathBuilder.subject = this.getSubjectOrNull();
                    break;
                }
                default: {
                    throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Criterion <{0}> is unhandled.", new Object[]{topicPathBuilder.criterion})).build();
                }
            }
            return topicPathBuilder.build();
        }

        private String tryToGetNamespace() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no namespace part.").cause((Throwable)e).build();
            }
        }

        private String tryToGetEntityName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no entity name part.").cause((Throwable)e).build();
            }
        }

        private String tryToGetGroupName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no group part.").cause((Throwable)e).build();
            }
        }

        private TopicPath.Group tryToGetGroup(String groupName) {
            return TopicPath.Group.forName(groupName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Group name <{0}> is unknown.", groupName)).build());
        }

        private TopicPath.Channel tryToGetChannelForGroup(TopicPath.Group group) {
            TopicPath.Channel result = TopicPath.Group.POLICIES == group || TopicPath.Group.CONNECTIONS == group ? TopicPath.Channel.NONE : this.tryToGetChannelForName(this.tryToGetChannelName());
            return result;
        }

        private String tryToGetChannelName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no channel part.").cause((Throwable)e).build();
            }
        }

        private TopicPath.Channel tryToGetChannelForName(String channelName) {
            return TopicPath.Channel.forName(channelName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Channel name <{0}> is unknown.", channelName)).build());
        }

        private String tryToGetCriterionName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no criterion part.").cause((Throwable)e).build();
            }
        }

        private TopicPath.Criterion tryToGetCriterion(String criterionName) {
            return TopicPath.Criterion.forName(criterionName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Criterion name <{0}> is unknown.", criterionName)).build());
        }

        private String tryToGetActionName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no action part.").cause((Throwable)e).build();
            }
        }

        private TopicPath.Action tryToGetActionForName(String actionName) {
            return TopicPath.Action.forName(actionName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Action name <{0}> is unknown.", actionName)).build());
        }

        private String tryToGetSearchActionName() {
            try {
                return this.topicPathParts.pop();
            }
            catch (NoSuchElementException e) {
                throw (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description("The topic path has no search action part.").cause((Throwable)e).build();
            }
        }

        private TopicPath.SearchAction tryToGetSearchActionForName(String searchActionName) {
            return TopicPath.SearchAction.forName(searchActionName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Search action name <{0}> is unknown.", searchActionName)).build());
        }

        private TopicPath.StreamingAction tryToGetStreamingActionForName(String streamingActionName) {
            return TopicPath.StreamingAction.forName(streamingActionName).orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(this.topicPathString).description(MessageFormat.format("Streaming action name <{0}> is unknown.", streamingActionName)).build());
        }

        @Nullable
        private String getSubjectOrNull() {
            String subject = String.join((CharSequence)"/", this.topicPathParts);
            String result = subject.isEmpty() ? null : subject;
            return result;
        }
    }
}

