/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.ImmutableMessagePath;
import org.eclipse.ditto.protocol.ImmutableTopicPath;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.PayloadBuilder;

@Immutable
final class ImmutablePayload
implements Payload {
    private final MessagePath path;
    @Nullable
    private final JsonValue value;
    @Nullable
    private final JsonObject extra;
    @Nullable
    private final HttpStatus status;
    @Nullable
    private final Long revision;
    @Nullable
    private final Instant timestamp;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final JsonFieldSelector fields;

    private ImmutablePayload(ImmutablePayloadBuilder builder) {
        this.path = builder.path;
        this.value = builder.value;
        this.extra = builder.extra;
        this.status = builder.status;
        this.revision = builder.revision;
        this.timestamp = builder.timestamp;
        this.metadata = builder.metadata;
        this.fields = builder.fields;
    }

    public static ImmutablePayloadBuilder getBuilder(@Nullable JsonPointer path) {
        return new ImmutablePayloadBuilder(path);
    }

    public static ImmutablePayload fromJson(JsonObject jsonObject) {
        String readPath = (String)jsonObject.getValueOrThrow(Payload.JsonFields.PATH);
        ImmutablePayloadBuilder payloadBuilder = ImmutablePayload.getBuilder(ImmutableTopicPath.newTopicOrPathPointer(readPath)).withValue(jsonObject.getValue(Payload.JsonFields.VALUE).orElse(null)).withExtra(jsonObject.getValue(Payload.JsonFields.EXTRA).orElse(null)).withStatus(jsonObject.getValue(Payload.JsonFields.STATUS).flatMap(HttpStatus::tryGetInstance).orElse(null)).withTimestamp(jsonObject.getValue(Payload.JsonFields.TIMESTAMP).map(Instant::parse).orElse(null)).withMetadata(jsonObject.getValue(Payload.JsonFields.METADATA).map(Metadata::newMetadata).orElse(null)).withFields((JsonFieldSelector)jsonObject.getValue(Payload.JsonFields.FIELDS).map(JsonFactory::parseJsonFieldSelector).orElse(null));
        jsonObject.getValue(Payload.JsonFields.REVISION).ifPresent(payloadBuilder::withRevision);
        return payloadBuilder.build();
    }

    @Override
    public MessagePath getPath() {
        return this.path;
    }

    @Override
    public Optional<JsonValue> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<JsonObject> getExtra() {
        return Optional.ofNullable(this.extra);
    }

    @Override
    public Optional<HttpStatus> getHttpStatus() {
        return Optional.ofNullable(this.status);
    }

    @Override
    public Optional<Long> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    @Override
    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public Optional<JsonFieldSelector> getFields() {
        return Optional.ofNullable(this.fields);
    }

    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonObject.newBuilder();
        jsonObjectBuilder.set(Payload.JsonFields.PATH, (Object)this.path.toString());
        if (null != this.value) {
            jsonObjectBuilder.set(Payload.JsonFields.VALUE, (Object)this.value);
        }
        if (null != this.extra) {
            jsonObjectBuilder.set(Payload.JsonFields.EXTRA, (Object)this.extra);
        }
        if (null != this.status) {
            jsonObjectBuilder.set(Payload.JsonFields.STATUS, (Object)this.status.getCode());
        }
        if (null != this.revision) {
            jsonObjectBuilder.set(Payload.JsonFields.REVISION, (Object)this.revision);
        }
        if (null != this.timestamp) {
            jsonObjectBuilder.set(Payload.JsonFields.TIMESTAMP, (Object)this.timestamp.toString());
        }
        if (null != this.metadata) {
            jsonObjectBuilder.set(Payload.JsonFields.METADATA, (Object)((JsonObject)this.metadata.toJson()));
        }
        if (null != this.fields) {
            jsonObjectBuilder.set(Payload.JsonFields.FIELDS, (Object)this.fields.toString());
        }
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePayload that = (ImmutablePayload)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.value, that.value) && Objects.equals(this.extra, that.extra) && Objects.equals(this.status, that.status) && Objects.equals(this.revision, that.revision) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.value, this.extra, this.status, this.revision, this.timestamp, this.metadata, this.fields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [path=" + this.path + ", value=" + this.value + ", extra=" + this.extra + ", status=" + this.status + ", revision=" + this.revision + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", fields=" + this.fields + "]";
    }

    @NotThreadSafe
    static final class ImmutablePayloadBuilder
    implements PayloadBuilder {
        @Nullable
        private MessagePath path;
        @Nullable
        private JsonValue value;
        @Nullable
        private JsonObject extra;
        @Nullable
        private HttpStatus status;
        @Nullable
        private Long revision;
        @Nullable
        private Instant timestamp;
        @Nullable
        private Metadata metadata;
        @Nullable
        private JsonFieldSelector fields;

        ImmutablePayloadBuilder(Payload payload) {
            this.path = payload.getPath();
            this.value = payload.getValue().orElse(null);
            this.extra = payload.getExtra().orElse(null);
            this.status = payload.getHttpStatus().orElse(null);
            this.revision = payload.getRevision().orElse(null);
            this.timestamp = payload.getTimestamp().orElse(null);
            this.metadata = payload.getMetadata().orElse(null);
            this.fields = payload.getFields().orElse(null);
        }

        private ImmutablePayloadBuilder(JsonPointer path) {
            this.path = ImmutablePayloadBuilder.toMessagePath(path);
            this.value = null;
            this.extra = null;
            this.status = null;
            this.timestamp = null;
            this.metadata = null;
            this.fields = null;
        }

        @Override
        public PayloadBuilder withPath(@Nullable JsonPointer path) {
            this.path = ImmutablePayloadBuilder.toMessagePath(path);
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withValue(@Nullable JsonValue value) {
            this.value = value;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withExtra(@Nullable JsonObject extra) {
            this.extra = extra;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withStatus(@Nullable HttpStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withRevision(long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withTimestamp(@Nullable Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withFields(@Nullable JsonFieldSelector fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public ImmutablePayloadBuilder withFields(@Nullable String fields) {
            this.fields = null != fields ? JsonFieldSelector.newInstance((CharSequence)fields, (CharSequence[])new CharSequence[0]) : null;
            return this;
        }

        @Override
        public ImmutablePayload build() {
            return new ImmutablePayload(this);
        }

        private static MessagePath toMessagePath(JsonPointer path) {
            ConditionChecker.checkNotNull((Object)path, (String)"path");
            if (path instanceof MessagePath) {
                return (MessagePath)path;
            }
            return ImmutableMessagePath.of(path);
        }
    }
}

