/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.messages.model.MessageDirection;
import org.eclipse.ditto.protocol.MessagePath;

@Immutable
final class ImmutableMessagePath
implements MessagePath {
    private static final JsonKey FEATURES = JsonKey.of((CharSequence)"features");
    private final JsonPointer jsonPointer;

    private ImmutableMessagePath(JsonPointer jsonPointer) {
        this.jsonPointer = jsonPointer;
    }

    public static MessagePath of(JsonPointer jsonPointer) {
        ConditionChecker.checkNotNull((Object)jsonPointer, (String)"JSON pointer");
        return new ImmutableMessagePath(jsonPointer);
    }

    @Override
    public Optional<String> getFeatureId() {
        return this.jsonPointer.getRoot().filter(arg_0 -> ((JsonKey)FEATURES).equals(arg_0)).map(features -> this.jsonPointer.nextLevel()).flatMap(JsonPointer::getRoot).map(CharSequence::toString);
    }

    @Override
    public Optional<MessageDirection> getDirection() {
        return this.jsonPointer.getRoot().flatMap(MessagePath::jsonKeyToDirection).map(Optional::of).orElseGet(() -> this.jsonPointer.getRoot().filter(arg_0 -> ((JsonKey)FEATURES).equals(arg_0)).flatMap(features -> this.jsonPointer.get(2)).flatMap(MessagePath::jsonKeyToDirection));
    }

    @Override
    public Optional<String> getMessageSubject() {
        if (this.isInboxOutboxMessage()) {
            return Optional.ofNullable(this.jsonPointer.getRoot().flatMap(MessagePath::jsonKeyToDirection).flatMap(direction -> this.jsonPointer.getSubPointer(2)).orElseGet(() -> this.jsonPointer.getRoot().filter(arg_0 -> ((JsonKey)FEATURES).equals(arg_0)).flatMap(features -> this.jsonPointer.get(2)).flatMap(MessagePath::jsonKeyToDirection).flatMap(direction -> this.jsonPointer.getSubPointer(4)).orElse(null))).map(JsonPointer::toString).map(s -> s.startsWith("/") ? s.substring(1) : s);
        }
        return Optional.empty();
    }

    public JsonPointer addLeaf(JsonKey key) {
        return this.jsonPointer.addLeaf(key);
    }

    public JsonPointer append(JsonPointer pointer) {
        return this.jsonPointer.append(pointer);
    }

    public int getLevelCount() {
        return this.jsonPointer.getLevelCount();
    }

    public boolean isEmpty() {
        return this.jsonPointer.isEmpty();
    }

    public Optional<JsonKey> get(int level) {
        return this.jsonPointer.get(level);
    }

    public Optional<JsonKey> getRoot() {
        return this.jsonPointer.getRoot();
    }

    public Optional<JsonKey> getLeaf() {
        return this.jsonPointer.getLeaf();
    }

    public JsonPointer cutLeaf() {
        return this.jsonPointer.cutLeaf();
    }

    public JsonPointer nextLevel() {
        return this.jsonPointer.nextLevel();
    }

    public Optional<JsonPointer> getSubPointer(int level) {
        return this.jsonPointer.getSubPointer(level);
    }

    public Optional<JsonPointer> getPrefixPointer(int level) {
        return this.jsonPointer.getPrefixPointer(level);
    }

    public JsonFieldSelector toFieldSelector() {
        return this.jsonPointer.toFieldSelector();
    }

    public int length() {
        return this.jsonPointer.length();
    }

    public char charAt(int index) {
        return this.jsonPointer.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.jsonPointer.subSequence(start, end);
    }

    public Iterator<JsonKey> iterator() {
        return this.jsonPointer.iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMessagePath that = (ImmutableMessagePath)o;
        return Objects.equals(this.jsonPointer, that.jsonPointer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonPointer);
    }

    public String toString() {
        return this.jsonPointer.toString();
    }
}

