/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.ImmutableAdaptable;
import org.eclipse.ditto.protocol.JsonifiableAdaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;

@Immutable
final class ImmutableJsonifiableAdaptable
implements JsonifiableAdaptable {
    private final Adaptable delegateAdaptable;

    private ImmutableJsonifiableAdaptable(Adaptable delegateAdaptable) {
        this.delegateAdaptable = delegateAdaptable;
    }

    public static JsonifiableAdaptable of(Adaptable delegateAdaptable) {
        Objects.requireNonNull(delegateAdaptable, "delegate adaptable");
        return new ImmutableJsonifiableAdaptable(delegateAdaptable);
    }

    public static ImmutableJsonifiableAdaptable fromJson(JsonObject jsonObject) {
        DittoHeaders headers = jsonObject.getValue(JsonifiableAdaptable.JsonFields.HEADERS).map(ProtocolFactory::newHeaders).orElse(DittoHeaders.empty());
        return new ImmutableJsonifiableAdaptable(ImmutableAdaptable.of(ImmutableJsonifiableAdaptable.tryToDeserializeTopicPath(jsonObject, headers), ProtocolFactory.newPayload(jsonObject), headers));
    }

    private static TopicPath tryToDeserializeTopicPath(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        try {
            return ImmutableJsonifiableAdaptable.deserializeTopicPath(jsonObject);
        }
        catch (DittoRuntimeException e) {
            throw (DittoRuntimeException)e.setDittoHeaders(dittoHeaders);
        }
    }

    private static TopicPath deserializeTopicPath(JsonObject jsonObject) {
        return ProtocolFactory.newTopicPath((String)jsonObject.getValueOrThrow(JsonifiableAdaptable.JsonFields.TOPIC));
    }

    @Override
    public TopicPath getTopicPath() {
        return this.delegateAdaptable.getTopicPath();
    }

    @Override
    public Payload getPayload() {
        return this.delegateAdaptable.getPayload();
    }

    @Override
    public boolean containsHeaderForKey(CharSequence key) {
        return this.delegateAdaptable.containsHeaderForKey(key);
    }

    public JsonObject toJson() {
        return this.toJson(this.getDittoHeaders());
    }

    @Override
    public JsonObject toJson(DittoHeaders specificHeaders) {
        return JsonObject.newBuilder().set(JsonifiableAdaptable.JsonFields.TOPIC, (Object)this.getTopicPath().getPath()).set(JsonifiableAdaptable.JsonFields.HEADERS, (Object)((JsonObject)specificHeaders.toJson())).setAll((Iterable)this.getPayload().toJson()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableJsonifiableAdaptable that = (ImmutableJsonifiableAdaptable)o;
        return Objects.equals(this.delegateAdaptable, that.delegateAdaptable);
    }

    public int hashCode() {
        return Objects.hash(this.delegateAdaptable);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegateAdaptable=" + this.delegateAdaptable + "]";
    }

    public DittoHeaders getDittoHeaders() {
        return this.delegateAdaptable.getDittoHeaders();
    }

    @Override
    public JsonifiableAdaptable setDittoHeaders(@Nonnull DittoHeaders dittoHeaders) {
        return new ImmutableJsonifiableAdaptable((Adaptable)this.delegateAdaptable.setDittoHeaders(dittoHeaders));
    }
}

