/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.AdaptableBuilder;
import org.eclipse.ditto.protocol.ImmutableAdaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;

@NotThreadSafe
final class ImmutableAdaptableBuilder
implements AdaptableBuilder {
    private final TopicPath topicPath;
    private Payload payload;
    private DittoHeaders headers;

    private ImmutableAdaptableBuilder(TopicPath topicPath) {
        this.topicPath = topicPath;
    }

    public static ImmutableAdaptableBuilder of(TopicPath topicPath) {
        Objects.requireNonNull(topicPath, "topicPath");
        return new ImmutableAdaptableBuilder(topicPath);
    }

    @Override
    public AdaptableBuilder withPayload(Payload payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public AdaptableBuilder withHeaders(DittoHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public Adaptable build() {
        return ImmutableAdaptable.of(this.topicPath, this.payload, this.headers);
    }
}

