/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;

@Immutable
final class ImmutableAdaptable
implements Adaptable {
    private final TopicPath topicPath;
    private final Payload payload;
    private final DittoHeaders headers;

    private ImmutableAdaptable(TopicPath topicPath, Payload payload, DittoHeaders headers) {
        this.topicPath = topicPath;
        this.payload = payload;
        this.headers = headers;
    }

    public static ImmutableAdaptable of(TopicPath topicPath, Payload payload, @Nullable DittoHeaders headers) {
        ConditionChecker.checkNotNull((Object)topicPath, (String)"topicPath");
        ConditionChecker.checkNotNull((Object)payload, (String)"payload");
        return new ImmutableAdaptable(topicPath, payload, headers);
    }

    @Override
    public TopicPath getTopicPath() {
        return this.topicPath;
    }

    @Override
    public Payload getPayload() {
        return this.payload;
    }

    @Override
    public boolean containsHeaderForKey(CharSequence key) {
        return null != key && null != this.headers && this.headers.containsKey((Object)key.toString());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAdaptable that = (ImmutableAdaptable)o;
        return Objects.equals(this.topicPath, that.topicPath) && Objects.equals(this.payload, that.payload) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.topicPath, this.payload, this.headers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [topicPath=" + this.topicPath + ", payload=" + this.payload + ", headers=" + this.headers + ']';
    }

    public DittoHeaders getDittoHeaders() {
        return null != this.headers ? this.headers : DittoHeaders.empty();
    }

    public Adaptable setDittoHeaders(@Nonnull DittoHeaders dittoHeaders) {
        return new ImmutableAdaptable(this.topicPath, this.payload, dittoHeaders);
    }
}

