/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json.cbor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.ditto.json.SerializationContext;
import org.eclipse.ditto.json.cbor.ByteBufferOutputStream;

final class JacksonSerializationContext
implements SerializationContext {
    private final JsonGenerator jacksonGenerator;
    private final ControllableOutputStream outputStream;

    public JacksonSerializationContext(JsonFactory jacksonFactory, OutputStream outputStream) throws IOException {
        this.outputStream = new ControllableOutputStream(outputStream);
        this.jacksonGenerator = jacksonFactory.createGenerator((OutputStream)this.outputStream);
    }

    JacksonSerializationContext(OutputStream outputStream) throws IOException {
        this((JsonFactory)new CBORFactory(), outputStream);
    }

    public JacksonSerializationContext(JsonFactory jacksonFactory, ByteBuffer targetBuffer) throws IOException {
        this(jacksonFactory, new ByteBufferOutputStream(targetBuffer));
    }

    JsonGenerator getJacksonGenerator() {
        return this.jacksonGenerator;
    }

    public void close() throws IOException {
        this.jacksonGenerator.close();
    }

    public void flush() throws IOException {
        this.jacksonGenerator.flush();
    }

    public void writeCachedElement(byte[] cachedData) throws IOException {
        this.flush();
        this.outputStream.write(cachedData);
        this.informJacksonThatOneElementWasWritten();
    }

    public void writeNull() throws IOException {
        this.jacksonGenerator.writeNull();
    }

    public void writeBoolean(boolean state) throws IOException {
        this.jacksonGenerator.writeBoolean(state);
    }

    public void writeNumber(float number) throws IOException {
        this.jacksonGenerator.writeNumber(number);
    }

    public void writeNumber(double number) throws IOException {
        this.jacksonGenerator.writeNumber(number);
    }

    public void writeNumber(long number) throws IOException {
        this.jacksonGenerator.writeNumber(number);
    }

    public void writeNumber(int number) throws IOException {
        this.jacksonGenerator.writeNumber(number);
    }

    public void writeString(String text) throws IOException {
        this.jacksonGenerator.writeString(text);
    }

    public void writeFieldName(String name) throws IOException {
        this.jacksonGenerator.writeFieldName(name);
    }

    private void informJacksonThatOneElementWasWritten() throws IOException {
        this.outputStream.disable();
        this.jacksonGenerator.writeNull();
        this.jacksonGenerator.flush();
        this.outputStream.enable();
    }

    static final class ControllableOutputStream
    extends OutputStream {
        private final OutputStream target;
        private boolean enabled = true;

        ControllableOutputStream(OutputStream target) {
            this.target = target;
        }

        void enable() {
            this.enabled = true;
        }

        void disable() {
            this.enabled = false;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.enabled) {
                this.target.write(b);
            }
        }

        @Override
        public void write(byte[] a, int b, int c) throws IOException {
            if (this.enabled) {
                this.target.write(a, b, c);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.enabled) {
                this.target.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            this.target.flush();
        }

        @Override
        public void close() throws IOException {
            this.target.close();
        }
    }
}

