/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json.cbor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.CborFactory;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonNumber;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;
import org.eclipse.ditto.json.cbor.BinaryToHexConverter;
import org.eclipse.ditto.json.cbor.ByteBufferInputStream;
import org.eclipse.ditto.json.cbor.ByteBufferOutputStream;
import org.eclipse.ditto.json.cbor.JacksonSerializationContext;

public final class JacksonCborFactory
implements CborFactory {
    private static final CBORFactory JACKSON_CBOR_FACTORY = new CBORFactory();

    public boolean isCborAvailable() {
        return true;
    }

    public JsonValue readFrom(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        try {
            CBORParser parser = JACKSON_CBOR_FACTORY.createParser(bytes);
            return JacksonCborFactory.parseValue(parser, byteBuffer);
        }
        catch (IOException | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw JacksonCborFactory.createJsonParseException(byteBuffer, e);
        }
    }

    public JsonValue readFrom(byte[] bytes, int offset, int length) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, length).slice();
        try {
            CBORParser parser = JACKSON_CBOR_FACTORY.createParser(bytes, offset, length);
            return JacksonCborFactory.parseValue(parser, byteBuffer);
        }
        catch (IOException | IllegalArgumentException e) {
            throw JacksonCborFactory.createJsonParseException(byteBuffer, e);
        }
    }

    public JsonValue readFrom(ByteBuffer byteBuffer) {
        ByteBuffer slicedByteBuffer = byteBuffer.slice();
        try {
            CBORParser parser = JACKSON_CBOR_FACTORY.createParser(ByteBufferInputStream.of(slicedByteBuffer));
            return JacksonCborFactory.parseValue(parser, slicedByteBuffer);
        }
        catch (IOException | IllegalArgumentException e) {
            throw JacksonCborFactory.createJsonParseException(slicedByteBuffer, e);
        }
    }

    public byte[] toByteArray(JsonValue jsonValue) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JacksonCborFactory.writeToOutputStream(jsonValue, baos);
        return baos.toByteArray();
    }

    public ByteBuffer toByteBuffer(JsonValue jsonValue) throws IOException {
        return ByteBuffer.wrap(this.toByteArray(jsonValue));
    }

    public void writeToByteBuffer(JsonValue jsonValue, ByteBuffer byteBuffer) throws IOException {
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byteBuffer);
        JacksonCborFactory.writeToOutputStream(jsonValue, byteBufferOutputStream);
    }

    public byte[] createCborRepresentation(Map<String, JsonField> jsonFieldMap, int guessedSerializedSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(guessedSerializedSize);
        try (JacksonSerializationContext serializationContext = new JacksonSerializationContext(baos);){
            JacksonCborFactory.writeStartObjectWithLength(serializationContext, jsonFieldMap.size());
            for (JsonField jsonField : jsonFieldMap.values()) {
                jsonField.writeKeyAndValue((SerializationContext)serializationContext);
            }
            serializationContext.getJacksonGenerator().writeEndObject();
        }
        return baos.toByteArray();
    }

    public byte[] createCborRepresentation(List<JsonValue> list, int guessedSerializedSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(guessedSerializedSize);
        try (JacksonSerializationContext serializationContext = new JacksonSerializationContext(baos);){
            serializationContext.getJacksonGenerator().writeStartArray(list.size());
            for (JsonValue jsonValue : list) {
                jsonValue.writeValue((SerializationContext)serializationContext);
            }
            serializationContext.getJacksonGenerator().writeEndArray();
        }
        return baos.toByteArray();
    }

    private static void writeStartObjectWithLength(JacksonSerializationContext serializationContext, int length) throws IOException {
        JsonGenerator jacksonGenerator = serializationContext.getJacksonGenerator();
        if (jacksonGenerator instanceof CBORGenerator) {
            CBORGenerator cborGenerator = (CBORGenerator)jacksonGenerator;
            cborGenerator.writeStartObject(length);
        } else {
            jacksonGenerator.writeStartObject();
        }
    }

    private static JsonParseException createJsonParseException(ByteBuffer byteBuffer, Exception e) {
        return (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to parse CBOR value <{0}>", BinaryToHexConverter.createDebugMessageByTryingToConvertToHexString(byteBuffer))).cause((Throwable)e).build();
    }

    private static void writeToOutputStream(JsonValue jsonValue, OutputStream outputStream) throws IOException {
        JacksonSerializationContext serializationContext = new JacksonSerializationContext((com.fasterxml.jackson.core.JsonFactory)JACKSON_CBOR_FACTORY, outputStream);
        jsonValue.writeValue((SerializationContext)serializationContext);
        serializationContext.close();
    }

    private static JsonValue parseValue(CBORParser parser, ByteBuffer byteBuffer) throws IOException {
        return JacksonCborFactory.parseValue(parser, byteBuffer, parser.nextToken());
    }

    private static JsonValue parseValue(CBORParser parser, ByteBuffer byteBuffer, @Nullable JsonToken currentToken) throws IOException {
        if (currentToken == null) {
            throw new IOException("Unexpected end of input while expecting value.");
        }
        switch (currentToken) {
            case START_OBJECT: {
                return JacksonCborFactory.parseObject(parser, byteBuffer);
            }
            case START_ARRAY: {
                return JacksonCborFactory.parseArray(parser, byteBuffer);
            }
            case VALUE_STRING: {
                return JsonValue.of((String)parser.getValueAsString());
            }
            case VALUE_NUMBER_INT: {
                return JacksonCborFactory.getIntegerOrLong(parser.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                return JsonValue.of((double)parser.getDoubleValue());
            }
            case VALUE_TRUE: {
                return JsonValue.of((boolean)true);
            }
            case VALUE_FALSE: {
                return JsonValue.of((boolean)false);
            }
            case VALUE_NULL: {
                return JsonFactory.nullLiteral();
            }
            case END_ARRAY: 
            case FIELD_NAME: 
            case VALUE_EMBEDDED_OBJECT: 
            case END_OBJECT: {
                throw new IOException("Encountered unexpected token " + parser.currentToken() + " at position " + parser.getCurrentLocation() + " while parsing CBOR value.");
            }
        }
        throw new IOException("CBORParser returned unexpected token type: " + parser.currentToken());
    }

    private static JsonObject parseObject(CBORParser parser, ByteBuffer byteBuffer) throws IOException {
        LinkedHashMap<String, JsonField> map = new LinkedHashMap<String, JsonField>();
        long startOffset = parser.getTokenLocation().getByteOffset();
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            String key = parser.currentName();
            JsonField jsonField = JsonField.newInstance((CharSequence)key, (JsonValue)JacksonCborFactory.parseValue(parser, byteBuffer));
            map.put(key, jsonField);
        }
        long endOffset = parser.getTokenLocation().getByteOffset();
        return JsonFactory.createJsonObject(map, (byte[])JacksonCborFactory.getBytesFromInputSource(startOffset, endOffset, byteBuffer));
    }

    private static JsonArray parseArray(CBORParser parser, ByteBuffer byteBuffer) throws IOException {
        LinkedList<JsonValue> list = new LinkedList<JsonValue>();
        long startOffset = parser.getTokenLocation().getByteOffset();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            JsonValue jsonValue = JacksonCborFactory.parseValue(parser, byteBuffer, parser.currentToken());
            list.add(jsonValue);
        }
        long endOffset = parser.getTokenLocation().getByteOffset();
        return JsonFactory.createJsonArray(list, (byte[])JacksonCborFactory.getBytesFromInputSource(startOffset, endOffset, byteBuffer));
    }

    private static byte[] getBytesFromInputSource(long startOffset, long endOffset, ByteBuffer byteBuffer) {
        assert (endOffset > startOffset);
        assert (endOffset < Integer.MAX_VALUE);
        int length = (int)(endOffset - startOffset);
        byte[] bytes = new byte[length];
        ByteBuffer duplicate = byteBuffer.duplicate();
        duplicate.position((int)startOffset);
        duplicate.get(bytes);
        return bytes;
    }

    private static JsonNumber getIntegerOrLong(long longValue) {
        if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
            return JsonValue.of((int)((int)longValue));
        }
        return JsonValue.of((long)longValue);
    }
}

