/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json.cbor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;

    private ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    static InputStream of(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.limit());
        }
        return new ByteBufferInputStream(byteBuffer);
    }

    @Override
    public int read() {
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (!this.byteBuffer.hasRemaining()) {
            return -1;
        }
        int dataToRead = Math.min(this.byteBuffer.remaining(), len);
        this.byteBuffer.get(b, off, dataToRead);
        return dataToRead;
    }
}

