/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.json.cbor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.ditto.json.cbor.ByteBufferInputStream;

public final class BinaryToHexConverter {
    private static final char[] HEXCHARACTERS = "0123456789ABCDEF".toCharArray();

    private BinaryToHexConverter() {
        throw new AssertionError();
    }

    public static String createDebugMessageByTryingToConvertToHexString(ByteBuffer byteBuffer) {
        ByteBuffer readOnlyByteBuffer = byteBuffer.asReadOnlyBuffer();
        try {
            return BinaryToHexConverter.toHexString(readOnlyByteBuffer);
        }
        catch (IOException e) {
            return "Could not convert ByteBuffer to String due to " + e.getClass().getSimpleName();
        }
    }

    public static String toHexString(byte[] array) throws IOException {
        return BinaryToHexConverter.toHexString(new ByteArrayInputStream(array));
    }

    public static String toHexString(ByteBuffer byteBuffer) throws IOException {
        return BinaryToHexConverter.toHexString(ByteBufferInputStream.of(byteBuffer));
    }

    public static String toHexString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(inputStream.available());
        int currentByte = inputStream.read();
        while (currentByte >= 0) {
            BinaryToHexConverter.appendByte((byte)currentByte, stringBuilder);
            currentByte = inputStream.read();
        }
        return stringBuilder.toString();
    }

    private static void appendByte(byte b, StringBuilder result) {
        result.append(HEXCHARACTERS[(b & 0xF0) >> 4]);
        result.append(HEXCHARACTERS[b & 0xF]);
    }
}

