/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.json.JsonParsableEvent;
import org.eclipse.ditto.base.model.signals.AbstractAnnotationBasedJsonParsableFactory;
import org.eclipse.ditto.base.model.signals.AbstractGlobalJsonParsableRegistry;
import org.eclipse.ditto.base.model.signals.JsonParsable;
import org.eclipse.ditto.base.model.signals.events.CustomizedGlobalEventRegistry;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.EventRegistry;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;

@Immutable
public final class GlobalEventRegistry<T extends Event<?>>
extends AbstractGlobalJsonParsableRegistry<T, JsonParsableEvent>
implements EventRegistry<T> {
    private static final GlobalEventRegistry<?> INSTANCE = new GlobalEventRegistry();

    private GlobalEventRegistry() {
        super(Event.class, JsonParsableEvent.class, new EventParsingStrategyFactory());
    }

    public static <T extends Event<?>> GlobalEventRegistry<T> getInstance() {
        return INSTANCE;
    }

    public CustomizedGlobalEventRegistry<T> customize(Map<String, JsonParsable<T>> parseStrategies) {
        return new CustomizedGlobalEventRegistry<T>(this, parseStrategies);
    }

    @Override
    protected String resolveType(JsonObject jsonObject) {
        return (String)jsonObject.getValue(Event.JsonFields.TYPE).orElseThrow(() -> new JsonMissingFieldException(Event.JsonFields.TYPE));
    }

    private static final class EventParsingStrategyFactory<T extends Event<?>>
    extends AbstractAnnotationBasedJsonParsableFactory<T, JsonParsableEvent> {
        private EventParsingStrategyFactory() {
        }

        @Override
        protected String getKeyFor(JsonParsableEvent annotation) {
            return annotation.typePrefix() + annotation.name();
        }

        @Override
        protected String getMethodNameFor(JsonParsableEvent annotation) {
            return annotation.method();
        }
    }
}

