/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.EventsourcedEvent;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
public final class EventJsonDeserializer<T extends Event<T>> {
    private final JsonObject jsonObject;
    private final String expectedType;

    public EventJsonDeserializer(String type, JsonObject jsonObject) {
        EventJsonDeserializer.validateType(ConditionChecker.argumentNotEmpty(type, "event type"));
        ConditionChecker.checkNotNull(jsonObject, "JSON object to be deserialized");
        this.jsonObject = jsonObject;
        this.expectedType = type;
    }

    private static void validateType(String type) {
        if (!type.contains(":")) {
            String msgPattern = "The type <{0}> does not contain a prefix separated by a colon (':')!";
            throw new IllegalArgumentException(MessageFormat.format("The type <{0}> does not contain a prefix separated by a colon (':')!", type));
        }
    }

    public EventJsonDeserializer(String type, String jsonString) {
        this(type, JsonFactory.newObject((String)jsonString));
    }

    public T deserialize(FactoryMethodFunction<T> factoryMethodFunction) {
        ConditionChecker.checkNotNull(factoryMethodFunction, "method for creating an event object");
        this.validateEventType();
        Long revision = this.jsonObject.getValue(EventsourcedEvent.JsonFields.REVISION).orElse(0L);
        Instant timestamp = this.jsonObject.getValue((CharSequence)Event.JsonFields.TIMESTAMP.getPointer()).filter(JsonValue::isString).map(JsonValue::asString).map(EventJsonDeserializer::tryToParseModified).orElse(null);
        Metadata metadata = this.jsonObject.getValue((CharSequence)Event.JsonFields.METADATA.getPointer()).filter(jsonValue -> !jsonValue.isNull() && jsonValue.isObject()).map(JsonValue::asObject).map(Metadata::newMetadata).orElse(null);
        return factoryMethodFunction.create(revision, timestamp, metadata);
    }

    private void validateEventType() {
        String type = (String)this.jsonObject.getValue(Event.JsonFields.TYPE).orElseThrow(() -> new JsonMissingFieldException((CharSequence)Event.JsonFields.TYPE.getPointer()));
        if (!this.expectedType.equals(type)) {
            String msgPattern = "Event JSON was not a <{0}> event but a <{1}>!";
            String msg = MessageFormat.format("Event JSON was not a <{0}> event but a <{1}>!", this.expectedType, type);
            throw new DittoJsonException((RuntimeException)((Object)new JsonParseException(msg)));
        }
    }

    private static Instant tryToParseModified(CharSequence dateTime) {
        try {
            return Instant.parse(dateTime);
        }
        catch (DateTimeParseException e) {
            throw new JsonParseException("The JSON object's field '_modified' is not in ISO-8601 format as expected");
        }
    }

    @FunctionalInterface
    public static interface FactoryMethodFunction<T extends Event<T>> {
        public T create(long var1, @Nullable Instant var3, @Nullable Metadata var4);
    }
}

