/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.atteo.classindex.IndexSubclasses;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.WithOptionalEntity;
import org.eclipse.ditto.base.model.signals.WithType;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;

@IndexSubclasses
public interface Event<T extends Event<T>>
extends Signal<T>,
WithOptionalEntity {
    public static final String TYPE_QUALIFIER = "events";
    public static final long DEFAULT_REVISION = 0L;

    @Override
    public String getType();

    @Override
    default public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.getDittoHeaders().getSchemaVersion().orElse(this.getLatestSchemaVersion());
    }

    public Optional<Instant> getTimestamp();

    public Optional<Metadata> getMetadata();

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    public static boolean isLiveEvent(@Nullable Signal<?> signal) {
        return Event.isEvent(signal) && Signal.isChannelLive(signal);
    }

    public static boolean isEvent(@Nullable Signal<?> signal) {
        return signal instanceof Event;
    }

    public static boolean isThingEvent(@Nullable WithType signal) {
        return WithType.hasTypePrefix(signal, "things.events:");
    }

    public static class JsonFields {
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> TIMESTAMP = JsonFactory.newStringFieldDefinition((CharSequence)"_timestamp", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> METADATA = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"_metadata", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

