/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.signals.AbstractJsonParsableRegistry;
import org.eclipse.ditto.base.model.signals.JsonParsable;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.EventRegistry;
import org.eclipse.ditto.base.model.signals.events.GlobalEventRegistry;
import org.eclipse.ditto.json.JsonObject;

public class CustomizedGlobalEventRegistry<T extends Event<?>>
extends AbstractJsonParsableRegistry<T>
implements EventRegistry<T> {
    private final GlobalEventRegistry<T> globalEventRegistry;

    CustomizedGlobalEventRegistry(GlobalEventRegistry<T> globalEventRegistry, Map<String, JsonParsable<T>> customParseStrategies) {
        super(CustomizedGlobalEventRegistry.mergeParseStrategy(globalEventRegistry, customParseStrategies));
        this.globalEventRegistry = globalEventRegistry;
    }

    private static <T extends Event<?>> Map<String, JsonParsable<T>> mergeParseStrategy(GlobalEventRegistry<T> globalEventRegistry, Map<String, JsonParsable<T>> customParseStrategies) {
        HashMap combinedStrategy = new HashMap();
        globalEventRegistry.getTypes().forEach(type -> combinedStrategy.put((String)type, globalEventRegistry));
        combinedStrategy.putAll(customParseStrategies);
        return combinedStrategy;
    }

    @Override
    protected String resolveType(JsonObject jsonObject) {
        return this.globalEventRegistry.resolveType(jsonObject);
    }
}

