/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.time.Instant;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.base.model.signals.events.AbstractEvent;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.base.model.signals.events.EventsourcedEvent;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@Immutable
public abstract class AbstractEventsourcedEvent<T extends AbstractEventsourcedEvent<T>>
extends AbstractEvent<T>
implements EventsourcedEvent<T> {
    private final EntityId entityId;
    private final long revision;
    private final JsonFieldDefinition<String> entityIdFieldDefinition;

    protected AbstractEventsourcedEvent(String type, EntityId entityId, @Nullable Instant timestamp, DittoHeaders dittoHeaders, @Nullable Metadata metadata, long revision, JsonFieldDefinition<String> entityIdFieldDefinition) {
        super(type, timestamp, dittoHeaders, metadata);
        this.entityId = ConditionChecker.checkNotNull(entityId, "entityId");
        this.revision = revision;
        this.entityIdFieldDefinition = entityIdFieldDefinition;
    }

    @Override
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    public abstract T setRevision(long var1);

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(Event.JsonFields.TYPE, (Object)this.getType()).set(Event.JsonFields.TIMESTAMP, (Object)this.getTimestamp().map(Instant::toString).orElse(null), predicate).set(Event.JsonFields.METADATA, (Object)this.getMetadata().map(Jsonifiable::toJson).orElse(null), predicate).set(EventsourcedEvent.JsonFields.REVISION, (Object)this.revision, predicate).set(this.entityIdFieldDefinition, (Object)this.entityId.toString());
        this.appendPayload(jsonObjectBuilder, schemaVersion, thePredicate);
        return jsonObjectBuilder.build();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractEventsourcedEvent that = (AbstractEventsourcedEvent)o;
        return that.canEqual(this) && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.revision, that.revision) && Objects.equals(this.entityIdFieldDefinition, that.entityIdFieldDefinition);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractEventsourcedEvent;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.entityId);
        result = 31 * result + Objects.hashCode(this.revision);
        result = 31 * result + Objects.hashCode(this.entityIdFieldDefinition);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", entityId=" + this.entityId + ", revision=" + this.revision;
    }
}

