/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.events;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.base.model.signals.events.Event;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@Immutable
public abstract class AbstractEvent<T extends AbstractEvent<T>>
implements Event<T> {
    private final String type;
    @Nullable
    private final Instant timestamp;
    private final DittoHeaders dittoHeaders;
    @Nullable
    private final Metadata metadata;

    protected AbstractEvent(String type, @Nullable Instant timestamp, DittoHeaders dittoHeaders, @Nullable Metadata metadata) {
        this.type = ConditionChecker.checkNotNull(type, "type");
        this.timestamp = timestamp;
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders").isResponseRequired() ? dittoHeaders.toBuilder().responseRequired(false).build() : dittoHeaders;
        this.metadata = metadata;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    @Nonnull
    public String getManifest() {
        return this.getType();
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(Event.JsonFields.TYPE, (Object)this.type).set(Event.JsonFields.TIMESTAMP, (Object)this.getTimestamp().map(Instant::toString).orElse(null), predicate).set(Event.JsonFields.METADATA, (Object)this.getMetadata().map(Jsonifiable::toJson).orElse(null), predicate);
        this.appendPayload(jsonObjectBuilder, schemaVersion, thePredicate);
        return jsonObjectBuilder.build();
    }

    protected abstract void appendPayload(JsonObjectBuilder var1, JsonSchemaVersion var2, Predicate<JsonField> var3);

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEvent that = (AbstractEvent)o;
        return that.canEqual(this) && Objects.equals(this.type, that.type) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.dittoHeaders, that.dittoHeaders) && Objects.equals(this.metadata, that.metadata);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractEvent;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.timestamp, this.dittoHeaders, this.metadata);
    }

    public String toString() {
        return "type=" + this.type + ", timestamp=" + this.timestamp + ", dittoHeaders=" + this.dittoHeaders + ", metadata=" + this.metadata;
    }
}

