/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;

@JsonParsableException(errorCode="signals.commands:path.unknown")
public class PathUnknownException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "signals.commands:path.unknown";
    private static final String MESSAGE_TEMPLATE = "The path ''{0}'' does not correspond to any known command, response or event.";
    private static final String DEFAULT_DESCRIPTION = "Check if the path is correct.";
    private static final long serialVersionUID = 5180713296695564798L;

    private PathUnknownException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(JsonPointer path) {
        return new Builder(path);
    }

    public static PathUnknownException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static PathUnknownException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PathUnknownException> {
        private Builder() {
            this.description(PathUnknownException.DEFAULT_DESCRIPTION);
        }

        public Builder(JsonPointer path) {
            this();
            this.message(MessageFormat.format(PathUnknownException.MESSAGE_TEMPLATE, path.toString()));
        }

        @Override
        protected PathUnknownException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PathUnknownException(dittoHeaders, message, description, cause, href);
        }
    }
}

