/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="command.timeout")
@Immutable
public final class CommandTimeoutException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "command.timeout";
    private static final String MESSAGE_TEMPLATE = "The Command reached the specified timeout of {0}ms.";
    private static final String DEFAULT_DESCRIPTION = "Try increasing the command timeout.";
    private static final long serialVersionUID = -3732435554989623073L;

    private CommandTimeoutException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.REQUEST_TIMEOUT, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(Duration timeout) {
        return new Builder(ConditionChecker.checkNotNull(timeout, "timeout"));
    }

    public static CommandTimeoutException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static CommandTimeoutException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CommandTimeoutException> {
        private Builder() {
            this.description(CommandTimeoutException.DEFAULT_DESCRIPTION);
        }

        private Builder(Duration timeout) {
            this();
            this.message(MessageFormat.format(CommandTimeoutException.MESSAGE_TEMPLATE, timeout.toMillis()));
        }

        @Override
        protected CommandTimeoutException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CommandTimeoutException(dittoHeaders, message, description, cause, href);
        }
    }
}

