/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonKey;

public final class ResourceMap<T>
extends HashMap<JsonKey, ResourceMap<T>> {
    private static final JsonKey ONE_LEVEL = JsonKey.of((CharSequence)"*");
    private static final JsonKey ANY_LEVEL = JsonKey.of((CharSequence)"**");
    private final T resource;

    private ResourceMap(T resource) {
        this.resource = resource;
    }

    public static <T> ResourceMapBuilder<T> newBuilder(T root) {
        return new ResourceMapBuilder(root);
    }

    public Optional<T> seek(Iterator<JsonKey> path) {
        if (path.hasNext()) {
            JsonKey key = path.next();
            if (this.containsKey(ONE_LEVEL)) {
                return ((ResourceMap)this.get(ONE_LEVEL)).seek(path);
            }
            if (this.containsKey(ANY_LEVEL)) {
                return Optional.of(((ResourceMap)this.get(ANY_LEVEL)).getResource());
            }
            if (this.containsKey(key)) {
                return ((ResourceMap)this.get(key)).seek(path);
            }
            return Optional.empty();
        }
        return Optional.of(this.getResource());
    }

    private T getResource() {
        return this.resource;
    }

    public static class ResourceMapBuilder<T> {
        private final ResourceMap<T> map;

        private ResourceMapBuilder(T root) {
            this.map = new ResourceMap(root);
        }

        public ResourceMap<T> addAny(T resource) {
            this.map.put(ANY_LEVEL, new ResourceMap(resource));
            return this.end();
        }

        public ResourceMap<T> addOne(T resource) {
            this.map.put(ONE_LEVEL, new ResourceMap(resource));
            return this.end();
        }

        public ResourceMap<T> addOne(ResourceMap<T> child) {
            this.map.put(ONE_LEVEL, child);
            return this.end();
        }

        public ResourceMapBuilder<T> add(JsonFieldDefinition<?> definition, T resource) {
            return this.add((JsonKey)definition.getPointer().iterator().next(), resource);
        }

        public ResourceMapBuilder<T> add(JsonKey key, T resource) {
            this.map.put(key, new ResourceMap(resource));
            return this;
        }

        public ResourceMapBuilder<T> add(JsonFieldDefinition<?> definition, ResourceMap<T> child) {
            return this.add((JsonKey)definition.getPointer().iterator().next(), child);
        }

        public ResourceMapBuilder<T> add(JsonKey key, ResourceMap<T> child) {
            this.map.put(key, child);
            return this;
        }

        public ResourceMap<T> end() {
            return this.map;
        }
    }
}

