/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.common.HttpStatusCodeOutOfRangeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

public final class CommandResponseJsonDeserializer<T extends CommandResponse<?>> {
    private final String expectedCommandResponseType;
    private final DeserializationFunction<T> deserializationFunction;

    private CommandResponseJsonDeserializer(CharSequence type, DeserializationFunction<T> deserializationFunction) {
        this.expectedCommandResponseType = ConditionChecker.checkArgument(ConditionChecker.checkNotNull(type, "type").toString(), arg -> !arg.trim().isEmpty(), () -> "The type must not be empty or blank.");
        this.deserializationFunction = deserializationFunction;
    }

    private static JsonObject checkJsonObjectNotNull(@Nullable JsonObject jsonObject) {
        return ConditionChecker.checkNotNull(jsonObject, "jsonObject");
    }

    public static <T extends CommandResponse<?>> CommandResponseJsonDeserializer<T> newInstance(CharSequence type, DeserializationFunction<T> deserializationFunction) {
        return new CommandResponseJsonDeserializer<T>(type, ConditionChecker.checkNotNull(deserializationFunction, "deserializationFunction"));
    }

    public T deserialize(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        CommandResponseJsonDeserializer.checkJsonObjectNotNull(jsonObject);
        ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        try {
            return this.deserializationFunction.deserializeCommandResponse(new DefaultDeserializationContext(jsonObject, dittoHeaders, this.validateCommandResponseType(CommandResponseJsonDeserializer.deserializeCommandResponseTypeOrThrow(jsonObject)), CommandResponseJsonDeserializer.deserializeHttpStatusOrThrow(jsonObject)));
        }
        catch (Exception e) {
            throw this.newJsonParseException(e);
        }
    }

    private static String deserializeCommandResponseTypeOrThrow(JsonObject jsonObject) {
        return (String)jsonObject.getValueOrThrow(CommandResponse.JsonFields.TYPE);
    }

    private String validateCommandResponseType(String deserializedCommandResponseType) {
        if (this.expectedCommandResponseType.equals(deserializedCommandResponseType)) {
            return deserializedCommandResponseType;
        }
        throw new JsonParseException(MessageFormat.format("Value <{0}> for <{1}> does not match <{2}>.", deserializedCommandResponseType, CommandResponse.JsonFields.TYPE.getPointer(), this.expectedCommandResponseType));
    }

    private static HttpStatus deserializeHttpStatusOrThrow(JsonObject jsonObject) throws HttpStatusCodeOutOfRangeException {
        return HttpStatus.getInstance((Integer)jsonObject.getValueOrThrow(CommandResponse.JsonFields.STATUS));
    }

    private JsonParseException newJsonParseException(Exception cause) {
        String pattern = "Failed to deserialize JSON object to a command response of type <{0}>: {1}";
        return (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize JSON object to a command response of type <{0}>: {1}", this.expectedCommandResponseType, cause.getMessage())).cause((Throwable)cause).build();
    }

    @FunctionalInterface
    public static interface DeserializationFunction<T extends CommandResponse<?>> {
        public T deserializeCommandResponse(DeserializationContext var1);
    }

    @Immutable
    private static final class DefaultDeserializationContext
    implements DeserializationContext {
        private final JsonObject jsonObject;
        private final DittoHeaders dittoHeaders;
        private final String type;
        private final HttpStatus httpStatus;

        private DefaultDeserializationContext(JsonObject jsonObject, DittoHeaders dittoHeaders, String type, HttpStatus httpStatus) {
            this.jsonObject = CommandResponseJsonDeserializer.checkJsonObjectNotNull(jsonObject);
            this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
            this.type = ConditionChecker.checkNotNull(type, "type");
            this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        }

        @Override
        public JsonObject getJsonObject() {
            return this.jsonObject;
        }

        @Override
        public DittoHeaders getDittoHeaders() {
            return this.dittoHeaders;
        }

        @Override
        public String getDeserializedType() {
            return this.type;
        }

        @Override
        public HttpStatus getDeserializedHttpStatus() {
            return this.httpStatus;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultDeserializationContext that = (DefaultDeserializationContext)o;
            return this.jsonObject.equals(that.jsonObject) && this.dittoHeaders.equals(that.dittoHeaders) && this.type.equals(that.type) && this.httpStatus.equals(that.httpStatus);
        }

        public int hashCode() {
            return Objects.hash(this.jsonObject, this.dittoHeaders, this.type, this.httpStatus);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [jsonObject=" + this.jsonObject + ", dittoHeaders=" + this.dittoHeaders + ", type=" + this.type + ", httpStatus=" + this.httpStatus + "]";
        }
    }

    public static interface DeserializationContext {
        public JsonObject getJsonObject();

        public DittoHeaders getDittoHeaders();

        public String getDeserializedType();

        public HttpStatus getDeserializedHttpStatus();
    }
}

