/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.text.MessageFormat;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;

@Immutable
public final class CommandResponseHttpStatusValidator {
    private CommandResponseHttpStatusValidator() {
        throw new AssertionError();
    }

    public static HttpStatus validateHttpStatus(HttpStatus httpStatus, Collection<HttpStatus> allowedHttpStatuses, Class<? extends CommandResponse> commandResponseType) {
        ConditionChecker.argumentNotEmpty(allowedHttpStatuses, "allowedHttpStatuses");
        ConditionChecker.checkNotNull(commandResponseType, "commandResponseType");
        return ConditionChecker.checkArgument(ConditionChecker.checkNotNull(httpStatus, "httpStatus"), allowedHttpStatuses::contains, () -> MessageFormat.format("{0} is invalid. {1} only allows {2}.", httpStatus, commandResponseType.getSimpleName(), allowedHttpStatuses));
    }
}

