/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.atteo.classindex.IndexSubclasses;
import org.eclipse.ditto.base.model.common.ResponseType;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.WithType;
import org.eclipse.ditto.base.model.signals.commands.WithHttpStatus;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;

@IndexSubclasses
public interface CommandResponse<T extends CommandResponse<T>>
extends Signal<T>,
WithHttpStatus {
    public static final String TYPE_QUALIFIER = "responses";

    @Override
    public T setDittoHeaders(DittoHeaders var1);

    @Override
    default public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.getDittoHeaders().getSchemaVersion().orElse(this.getLatestSchemaVersion());
    }

    default public boolean isOfExpectedResponseType() {
        return this.getDittoHeaders().getExpectedResponseTypes().contains(this.getResponseType());
    }

    default public ResponseType getResponseType() {
        return ResponseType.RESPONSE;
    }

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion var1, Predicate<JsonField> var2);

    public static boolean isCommandResponse(@Nullable Signal<?> signal) {
        return signal instanceof CommandResponse;
    }

    public static boolean isLiveCommandResponse(@Nullable Signal<?> signal) {
        return CommandResponse.isMessageCommandResponse(signal) || CommandResponse.isCommandResponse(signal) && Signal.isChannelLive(signal);
    }

    public static boolean isThingCommandResponse(@Nullable WithType signal) {
        return WithType.hasTypePrefix(signal, "things.responses:");
    }

    public static boolean isMessageCommandResponse(@Nullable WithType signal) {
        return WithType.hasTypePrefix(signal, "messages.responses:");
    }

    @Immutable
    public static abstract class JsonFields {
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> STATUS = JsonFactory.newIntFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonValue> PAYLOAD = JsonFactory.newJsonValueFieldDefinition((CharSequence)"payload", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        protected JsonFields() {
        }
    }
}

