/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="api.version.notsupported")
@Immutable
public final class CommandNotSupportedException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "api.version.notsupported";
    private static final String MESSAGE_TEMPLATE = "The requested resource is not supported by version ''{0}''.";
    private static final String DEFAULT_DESCRIPTION = "Check if you specified the correct version of the API.";
    private static final long serialVersionUID = 317333904099138238L;

    private CommandNotSupportedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.NOT_FOUND, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(int version) {
        return new Builder(version);
    }

    public static CommandNotSupportedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static CommandNotSupportedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CommandNotSupportedException> {
        private Builder() {
            this.description(CommandNotSupportedException.DEFAULT_DESCRIPTION);
        }

        private Builder(int version) {
            this();
            this.message(MessageFormat.format(CommandNotSupportedException.MESSAGE_TEMPLATE, version));
        }

        @Override
        protected CommandNotSupportedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CommandNotSupportedException(dittoHeaders, message, description, cause, href);
        }
    }
}

