/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.text.MessageFormat;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

@Immutable
public final class CommandJsonDeserializer<T extends Command> {
    private final JsonObject jsonObject;
    private final String expectedCommandType;

    public CommandJsonDeserializer(String type, JsonObject jsonObject) {
        CommandJsonDeserializer.validateType(ConditionChecker.argumentNotEmpty(type, "command type"));
        ConditionChecker.checkNotNull(jsonObject, "JSON object to be deserialized");
        this.jsonObject = jsonObject;
        this.expectedCommandType = type;
    }

    private static void validateType(String type) {
        if (!type.contains(":")) {
            String msgPattern = "The type <{0}> does not contain a prefix separated by a colon (':')!";
            throw new IllegalArgumentException(MessageFormat.format("The type <{0}> does not contain a prefix separated by a colon (':')!", type));
        }
    }

    public CommandJsonDeserializer(String type, String jsonString) {
        this(type, JsonFactory.newObject((String)jsonString));
    }

    public T deserialize(Supplier<T> commandSupplier) {
        ConditionChecker.checkNotNull(commandSupplier, "supplier for a command object");
        this.validateCommandType();
        return (T)((Command)commandSupplier.get());
    }

    private void validateCommandType() {
        String actualCommandType = (String)this.jsonObject.getValueOrThrow(Command.JsonFields.TYPE);
        if (!this.expectedCommandType.equals(actualCommandType)) {
            String msgPattern = "Command JSON was not a <{0}> command but a <{1}>!";
            String msg = MessageFormat.format("Command JSON was not a <{0}> command but a <{1}>!", this.expectedCommandType, actualCommandType);
            throw new DittoJsonException((RuntimeException)((Object)new JsonParseException(msg)));
        }
    }
}

