/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="command.headers.invalid")
@Immutable
public final class CommandHeaderInvalidException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "command.headers.invalid";
    static final String MESSAGE_TEMPLATE = "The header ''{0}'' was invalid in context of the command.";
    private static final long serialVersionUID = -6234578123467834234L;

    private CommandHeaderInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(CharSequence headerKey) {
        return new Builder(headerKey);
    }

    public static CommandHeaderInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static CommandHeaderInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CommandHeaderInvalidException> {
        private Builder() {
        }

        private Builder(CharSequence headerKey) {
            this();
            this.message(MessageFormat.format(CommandHeaderInvalidException.MESSAGE_TEMPLATE, headerKey));
        }

        @Override
        protected CommandHeaderInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CommandHeaderInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

