/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.atteo.classindex.IndexSubclasses;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.base.model.signals.WithType;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;

@IndexSubclasses
public interface Command<T extends Command<T>>
extends Signal<T> {
    public static final String TYPE_QUALIFIER = "commands";

    public String getTypePrefix();

    public Category getCategory();

    @Override
    public T setDittoHeaders(DittoHeaders var1);

    @Override
    default public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.getDittoHeaders().getSchemaVersion().orElse(this.getLatestSchemaVersion());
    }

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion var1, Predicate<JsonField> var2);

    public static boolean isLiveCommand(@Nullable Signal<?> signal) {
        return Command.isMessageCommand(signal) || Command.isCommand(signal) && Signal.isChannelLive(signal);
    }

    public static boolean isThingCommand(@Nullable WithType signal) {
        return WithType.hasTypePrefix(signal, "things.commands:");
    }

    public static boolean isMessageCommand(@Nullable WithType signal) {
        return WithType.hasTypePrefix(signal, "messages.commands:");
    }

    public static boolean isCommand(@Nullable Signal<?> signal) {
        return signal instanceof Command;
    }

    @Immutable
    public static abstract class JsonFields {
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        protected JsonFields() {
        }
    }

    @Immutable
    public static enum Category {
        QUERY,
        CREATE,
        MODIFY,
        MERGE,
        DELETE,
        ACTION;


        public static boolean isEntityModifyingCommand(Category category) {
            return category == CREATE || category == MODIFY || category == MERGE || category == DELETE;
        }
    }
}

