/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.Map;
import java.util.function.Function;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.base.model.signals.commands.CommandToExceptionRegistry;

public abstract class AbstractCommandToExceptionRegistry<C extends Command<?>, T extends DittoRuntimeException>
implements CommandToExceptionRegistry<C, T> {
    private final Map<String, Function<C, T>> mappingStrategies;

    protected AbstractCommandToExceptionRegistry(Map<String, Function<C, T>> mappingStrategies) {
        this.mappingStrategies = mappingStrategies;
    }

    protected T fallback(C command) {
        throw new IllegalArgumentException("No exception mapping found for the passed-in Command: " + command.getType());
    }

    @Override
    public T exceptionFrom(C command) {
        return (T)this.mappingStrategies.getOrDefault(command.getType(), this::fallback).apply((Command)command);
    }
}

