/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;

public abstract class AbstractCommandSizeValidator<T extends DittoRuntimeException> {
    protected static final String DEFAULT_LIMIT = "-1";
    @Nullable
    private final Long maxSize;

    protected AbstractCommandSizeValidator(@Nullable Long maxSize) {
        this.maxSize = maxSize;
    }

    public Optional<Long> getMaxSize() {
        return Optional.ofNullable(this.maxSize);
    }

    public void ensureValidSize(LongSupplier sizeSupplier, Supplier<DittoHeaders> headersSupplier) {
        if (null != this.maxSize) {
            long actualSize = sizeSupplier.getAsLong();
            if (this.maxSize < actualSize) {
                throw this.newInvalidSizeException(this.maxSize, actualSize, headersSupplier.get());
            }
        }
    }

    public void ensureValidSize(LongSupplier upperBoundSupplier, LongSupplier sizeSupplier, Supplier<DittoHeaders> headersSupplier) {
        if (null != this.maxSize && upperBoundSupplier.getAsLong() >= this.maxSize) {
            this.ensureValidSize(sizeSupplier, headersSupplier);
        }
    }

    public void ensureValidSize(Jsonifiable<JsonObject> jsonifiable, JsonField jsonField, Supplier<DittoHeaders> headersSupplier) {
        this.ensureValidSize(() -> {
            JsonObject jsonWithField = ((JsonObject)jsonifiable.toJson()).setValue((CharSequence)jsonField.getKey(), jsonField.getValue());
            return jsonWithField.toString().length();
        }, headersSupplier);
    }

    protected abstract T newInvalidSizeException(long var1, long var3, DittoHeaders var5);
}

