/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

@Immutable
public abstract class AbstractCommandResponse<T extends AbstractCommandResponse<T>>
implements CommandResponse<T> {
    private final String responseType;
    private final HttpStatus httpStatus;
    private final DittoHeaders dittoHeaders;

    protected AbstractCommandResponse(String responseType, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        this.responseType = ConditionChecker.checkNotNull(responseType, "responseType");
        this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        this.dittoHeaders = AbstractCommandResponse.ensureNoResponseRequired(ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders"));
    }

    private static DittoHeaders ensureNoResponseRequired(DittoHeaders dittoHeaders) {
        DittoHeaders result = dittoHeaders.isResponseRequired() ? DittoHeaders.newBuilder(dittoHeaders).responseRequired(false).build() : dittoHeaders;
        return result;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getType() {
        return this.responseType;
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    @Nonnull
    public String getManifest() {
        return this.getType();
    }

    protected abstract void appendPayload(JsonObjectBuilder var1, JsonSchemaVersion var2, Predicate<JsonField> var3);

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(CommandResponse.JsonFields.TYPE, (Object)this.responseType, predicate).set(CommandResponse.JsonFields.STATUS, (Object)this.httpStatus.getCode(), predicate);
        this.appendPayload(jsonObjectBuilder, schemaVersion, thePredicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCommandResponse that = (AbstractCommandResponse)o;
        return that.canEqual(this) && Objects.equals(this.dittoHeaders, that.dittoHeaders) && Objects.equals(this.httpStatus, that.httpStatus) && Objects.equals(this.responseType, that.responseType);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractCommandResponse;
    }

    public int hashCode() {
        return Objects.hash(this.dittoHeaders, this.httpStatus, this.responseType);
    }

    public String toString() {
        return "dittoHeaders=" + this.dittoHeaders + ", responseType=" + this.responseType + ", httpStatus=" + this.httpStatus;
    }
}

