/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.commands;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.base.model.signals.commands.CommandHeaderInvalidException;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

public abstract class AbstractCommand<T extends AbstractCommand<T>>
implements Command<T> {
    private final String type;
    private final DittoHeaders dittoHeaders;

    protected AbstractCommand(String type, DittoHeaders dittoHeaders, Command.Category category) {
        this.type = ConditionChecker.checkNotNull(type, "type");
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        this.validateHeaders(category);
    }

    protected AbstractCommand(String type, DittoHeaders dittoHeaders) {
        this.type = ConditionChecker.checkNotNull(type, "type");
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        this.validateHeaders(this.getCategory());
    }

    private void validateHeaders(Command.Category category) {
        if (Command.Category.QUERY == category && !this.dittoHeaders.isResponseRequired()) {
            String headerKey = DittoHeaderDefinition.RESPONSE_REQUIRED.getKey();
            throw (CommandHeaderInvalidException)CommandHeaderInvalidException.newBuilder(headerKey).message(MessageFormat.format("Query commands must not have the header ''{0}'' set to 'false'", headerKey)).description(MessageFormat.format("Set the header ''{0}'' to 'true' instead in order to receive a response to your query command.", headerKey)).build();
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getManifest() {
        return this.getType();
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(Command.JsonFields.TYPE, (Object)this.type, predicate);
        this.appendPayload(jsonObjectBuilder, schemaVersion, thePredicate);
        return jsonObjectBuilder.build();
    }

    protected abstract void appendPayload(JsonObjectBuilder var1, JsonSchemaVersion var2, Predicate<JsonField> var3);

    public int hashCode() {
        return Objects.hash(this.dittoHeaders, this.type);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCommand other = (AbstractCommand)obj;
        return other.canEqual(this) && Objects.equals(this.dittoHeaders, other.dittoHeaders) && Objects.equals(this.type, other.type);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractCommand;
    }

    public String toString() {
        return "type=" + this.type + ", dittoHeaders=" + this.dittoHeaders;
    }
}

