/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.announcements;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.announcements.Announcement;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;

public abstract class AbstractAnnouncement<T extends AbstractAnnouncement<T>>
implements Announcement<T> {
    private final DittoHeaders dittoHeaders;

    protected AbstractAnnouncement(DittoHeaders dittoHeaders) {
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
    }

    protected abstract void appendPayload(JsonObjectBuilder var1, Predicate<JsonField> var2);

    @Override
    public String getManifest() {
        return this.getType();
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public JsonObject toJson() {
        return this.toJson(JsonSchemaVersion.LATEST, FieldType.all());
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Announcement.JsonFields.JSON_TYPE, (Object)this.getType(), predicate);
        this.appendPayload(jsonObjectBuilder, predicate);
        return jsonObjectBuilder.build();
    }

    public String toString() {
        return "type=" + this.getType() + ", dittoHeaders=" + this.dittoHeaders;
    }

    public boolean equals(Object other) {
        if (other != null) {
            return this.getClass().equals(other.getClass()) && Objects.equals(this.dittoHeaders, ((AbstractAnnouncement)other).dittoHeaders);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dittoHeaders);
    }
}

