/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.common.HttpStatusCodeOutOfRangeException;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.base.model.signals.acks.AcknowledgementJsonParser;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgements;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class AcknowledgementsJsonParser
implements BiFunction<JsonObject, DittoHeaders, Acknowledgements> {
    private final AcknowledgementJsonParser acknowledgementJsonParser;

    private AcknowledgementsJsonParser(AcknowledgementJsonParser acknowledgementJsonParser) {
        this.acknowledgementJsonParser = ConditionChecker.checkNotNull(acknowledgementJsonParser, "acknowledgementJsonParser");
    }

    public static AcknowledgementsJsonParser getInstance(AcknowledgementJsonParser acknowledgementJsonParser) {
        return new AcknowledgementsJsonParser(acknowledgementJsonParser);
    }

    @Override
    public Acknowledgements apply(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return this.tryToParseJsonObject(ConditionChecker.checkNotNull(jsonObject, "jsonObject"), dittoHeaders);
    }

    private Acknowledgements tryToParseJsonObject(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        try {
            return this.parseJsonObject(jsonObject, dittoHeaders);
        }
        catch (JsonMissingFieldException | JsonParseException e) {
            throw e;
        }
        catch (DittoRuntimeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).description((String)e.getDescription().orElse(null)).cause((Throwable)e).build();
        }
        catch (RuntimeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).cause((Throwable)e).build();
        }
    }

    private Acknowledgements parseJsonObject(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        EntityId entityId = this.getEntityId(jsonObject);
        List<Acknowledgement> acknowledgements = this.getAcknowledgements(jsonObject, entityId);
        Acknowledgements result = acknowledgements.isEmpty() ? Acknowledgements.empty(entityId, dittoHeaders) : Acknowledgements.of(acknowledgements, dittoHeaders);
        AcknowledgementsJsonParser.validateHttpStatus(AcknowledgementsJsonParser.getHttpStatus(jsonObject), result.getHttpStatus());
        return result;
    }

    private EntityId getEntityId(JsonObject jsonObject) {
        EntityType entityType = EntityType.of((CharSequence)jsonObject.getValueOrThrow(Acknowledgements.JsonFields.ENTITY_TYPE));
        String entityIdValue = (String)jsonObject.getValueOrThrow(Acknowledgements.JsonFields.ENTITY_ID);
        return this.acknowledgementJsonParser.tryToGetEntityId(entityType, entityIdValue);
    }

    private List<Acknowledgement> getAcknowledgements(JsonObject jsonObject, EntityId expectedEntityId) {
        JsonObject acknowledgements = (JsonObject)jsonObject.getValueOrThrow(Acknowledgements.JsonFields.ACKNOWLEDGEMENTS);
        Predicate<JsonField> isNotJsonSchemaVersion = field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey());
        return acknowledgements.stream().filter(isNotJsonSchemaVersion).flatMap(jsonField -> this.parseAcknowledgement((JsonField)jsonField, expectedEntityId)).collect(Collectors.toList());
    }

    private Stream<Acknowledgement> parseAcknowledgement(JsonField acknowledgementJsonField, EntityId expectedEntityId) {
        JsonValue acknowledgementJsonValue = acknowledgementJsonField.getValue();
        if (acknowledgementJsonValue.isArray()) {
            return acknowledgementJsonValue.asArray().stream().map(json -> this.parseAcknowledgementFromObject((JsonValue)json, expectedEntityId));
        }
        return Stream.of(this.parseAcknowledgementFromObject(acknowledgementJsonValue, expectedEntityId));
    }

    private Acknowledgement parseAcknowledgementFromObject(JsonValue jsonObject, EntityId expectedEntityId) {
        if (!jsonObject.isObject()) {
            String msgPattern = "<{0}> is not an Acknowledgement JSON object representation!";
            throw new JsonParseException(MessageFormat.format("<{0}> is not an Acknowledgement JSON object representation!", jsonObject));
        }
        Acknowledgement result = this.acknowledgementJsonParser.apply(jsonObject.asObject());
        this.validateEntityId(result, expectedEntityId);
        return result;
    }

    private void validateEntityId(Acknowledgement acknowledgement, EntityId expected) {
        EntityId actual = acknowledgement.getEntityId();
        if (!actual.equals(expected)) {
            String mPtrn = "The entity ID <{0}> of parsed acknowledgement <{1}> differs from the expected <{2}>!";
            throw new JsonParseException(MessageFormat.format("The entity ID <{0}> of parsed acknowledgement <{1}> differs from the expected <{2}>!", actual, acknowledgement, expected));
        }
    }

    private static HttpStatus getHttpStatus(JsonObject jsonObject) {
        Integer statusCode = (Integer)jsonObject.getValueOrThrow(Acknowledgements.JsonFields.STATUS_CODE);
        try {
            return HttpStatus.getInstance(statusCode);
        }
        catch (HttpStatusCodeOutOfRangeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).cause((Throwable)e).build();
        }
    }

    private static void validateHttpStatus(HttpStatus actual, HttpStatus expected) {
        if (!actual.equals(expected)) {
            String msgPattern = "The read status code <{0}> differs from the expected <{1}>!";
            throw new JsonParseException(MessageFormat.format("The read status code <{0}> differs from the expected <{1}>!", actual.getCode(), expected.getCode()));
        }
    }
}

