/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.common.ResponseType;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.entity.type.WithEntityType;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.headers.contenttype.ContentType;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableCommandResponse;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.SignalWithEntityId;
import org.eclipse.ditto.base.model.signals.WithOptionalEntity;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.base.model.signals.acks.AcknowledgementJsonParser;
import org.eclipse.ditto.base.model.signals.acks.AcknowledgementsJsonParser;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@JsonParsableCommandResponse(type="acknowledgements")
@Immutable
public final class Acknowledgements
implements Iterable<Acknowledgement>,
CommandResponse<Acknowledgements>,
WithOptionalEntity,
WithEntityType,
SignalWithEntityId<Acknowledgements> {
    static final String TYPE = "acknowledgements";
    private final EntityId entityId;
    private final List<Acknowledgement> acknowledgements;
    private final HttpStatus httpStatus;
    private final DittoHeaders dittoHeaders;

    private Acknowledgements(EntityId entityId, Collection<? extends Acknowledgement> acknowledgements, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        this.entityId = entityId;
        this.acknowledgements = Collections.unmodifiableList(new ArrayList<Acknowledgement>(acknowledgements));
        this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        DittoHeadersBuilder<?, ?> dittoHeadersBuilder = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders").isResponseRequired() ? dittoHeaders.toBuilder().responseRequired(false) : dittoHeaders.toBuilder();
        this.dittoHeaders = dittoHeadersBuilder.removeHeader(DittoHeaderDefinition.REQUESTED_ACKS.getKey()).build();
    }

    public static Acknowledgements of(Collection<? extends Acknowledgement> acknowledgements, DittoHeaders dittoHeaders) {
        ConditionChecker.argumentNotEmpty(acknowledgements, TYPE);
        return Acknowledgements.of(Acknowledgements.getEntityId(acknowledgements), acknowledgements, Acknowledgements.getCombinedHttpStatus(acknowledgements), dittoHeaders);
    }

    public static Acknowledgements of(EntityId entityId, Collection<? extends Acknowledgement> acknowledgements, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(entityId, "entityId");
        ConditionChecker.argumentNotEmpty(acknowledgements, TYPE);
        ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders");
        return new Acknowledgements(entityId, acknowledgements, httpStatus, dittoHeaders);
    }

    private static EntityId getEntityId(Iterable<? extends Acknowledgement> acknowledgements) {
        Iterator<? extends Acknowledgement> acknowledgementIterator = acknowledgements.iterator();
        Acknowledgement acknowledgement = acknowledgementIterator.next();
        EntityId entityId = acknowledgement.getEntityId();
        while (acknowledgementIterator.hasNext()) {
            acknowledgement = acknowledgementIterator.next();
            EntityId acknowledgementEntityId = acknowledgement.getEntityId();
            if (entityId.equals(acknowledgement.getEntityId())) continue;
            String pattern = "The entity ID <{0}> is not compatible with <{1}>!";
            throw new IllegalArgumentException(MessageFormat.format("The entity ID <{0}> is not compatible with <{1}>!", acknowledgementEntityId, entityId));
        }
        return entityId;
    }

    private static HttpStatus getCombinedHttpStatus(Collection<? extends Acknowledgement> acknowledgements) {
        Stream<? extends Acknowledgement> acknowledgementStream;
        boolean allAcknowledgementsSuccessful;
        HttpStatus result = 1 == acknowledgements.size() ? acknowledgements.stream().findFirst().map(Acknowledgement::getHttpStatus).orElse(HttpStatus.INTERNAL_SERVER_ERROR) : ((allAcknowledgementsSuccessful = (acknowledgementStream = acknowledgements.stream()).allMatch(Acknowledgement::isSuccess)) ? HttpStatus.OK : HttpStatus.FAILED_DEPENDENCY);
        return result;
    }

    public static Acknowledgements empty(EntityId entityId, DittoHeaders dittoHeaders) {
        List acknowledgements = Collections.emptyList();
        return new Acknowledgements(ConditionChecker.checkNotNull(entityId, "entityId"), acknowledgements, Acknowledgements.getCombinedHttpStatus(acknowledgements), dittoHeaders);
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public Set<AcknowledgementLabel> getMissingAcknowledgementLabels() {
        return this.stream().filter(Acknowledgement::isTimeout).map(Acknowledgement::getLabel).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Acknowledgement> getSuccessfulAcknowledgements() {
        return this.stream().filter(Acknowledgement::isSuccess).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Acknowledgement> getFailedAcknowledgements() {
        return this.stream().filter(acknowledgement -> !acknowledgement.isSuccess()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<Acknowledgement> getAcknowledgement(AcknowledgementLabel acknowledgementLabel) {
        return this.stream().filter(ack -> acknowledgementLabel.equals(ack.getLabel())).findAny();
    }

    @Override
    public Iterator<Acknowledgement> iterator() {
        return this.acknowledgements.iterator();
    }

    public int getSize() {
        return this.acknowledgements.size();
    }

    public boolean isEmpty() {
        return this.acknowledgements.isEmpty();
    }

    public Stream<Acknowledgement> stream() {
        return this.acknowledgements.stream();
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        if (this.acknowledgements.size() == 1) {
            return this.acknowledgements.get(0).getDittoHeaders().toBuilder().putHeaders(this.dittoHeaders).build();
        }
        return this.dittoHeaders;
    }

    @Override
    public Acknowledgements setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Acknowledgements(this.entityId, this.acknowledgements, this.httpStatus, dittoHeaders);
    }

    @Override
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityId.getEntityType();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        Optional<JsonValue> result;
        int acknowledgementsSize = this.acknowledgements.size();
        if (0 == acknowledgementsSize) {
            result = Optional.empty();
        } else if (1 == acknowledgementsSize) {
            Acknowledgement soleAcknowledgement = this.acknowledgements.get(0);
            result = soleAcknowledgement.getEntity(schemaVersion);
        } else {
            result = Optional.of(this.acknowledgementsEntitiesToJson(schemaVersion));
        }
        return result;
    }

    private JsonObject acknowledgementsEntitiesToJson(JsonSchemaVersion schemaVersion) {
        return this.acknowledgementsToJsonWithDisambiguation(schemaVersion, FieldType.all(), (ack, version, predicate) -> {
            JsonObjectBuilder jsonObjectBuilder = JsonObject.newBuilder().set(Acknowledgement.JsonFields.STATUS_CODE, (Object)ack.getHttpStatus().getCode());
            Optional<JsonValue> ackEntity = ack.getEntity(version);
            ackEntity.ifPresent(ae -> jsonObjectBuilder.set(Acknowledgement.JsonFields.PAYLOAD, ae));
            DittoHeaders ackHeaders = ack.getDittoHeaders();
            jsonObjectBuilder.set(Acknowledgement.JsonFields.DITTO_HEADERS, (Object)Acknowledgements.buildHeadersJson(ackHeaders));
            return jsonObjectBuilder.build();
        });
    }

    private static JsonObject buildHeadersJson(DittoHeaders dittoHeaders) {
        boolean containsDittoContentType = dittoHeaders.getDittoContentType().filter(ContentType::isDittoProtocol).isPresent();
        if (containsDittoContentType) {
            return (JsonObject)dittoHeaders.toBuilder().removeHeader(DittoHeaderDefinition.CONTENT_TYPE.getKey()).build().toJson();
        }
        return (JsonObject)dittoHeaders.toJson();
    }

    private JsonObject acknowledgementsToJsonWithDisambiguation(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate, AcknowledgementToJson acknowledgementToJson) {
        LinkedHashMap<CharSequence, JsonArrayBuilder> disambiguationMap = new LinkedHashMap<CharSequence, JsonArrayBuilder>();
        for (Acknowledgement ack : this.acknowledgements) {
            disambiguationMap.compute(ack.getLabel(), (label, previousBuilder) -> {
                JsonArrayBuilder builder = previousBuilder == null ? JsonArray.newBuilder() : previousBuilder;
                return builder.add((JsonValue)acknowledgementToJson.toJson(ack, schemaVersion, predicate), new JsonValue[0]);
            });
        }
        return (JsonObject)disambiguationMap.entrySet().stream().map(entry -> {
            JsonArray array = ((JsonArrayBuilder)entry.getValue()).build();
            JsonArray value = array.getSize() == 1 ? (JsonValue)array.get(0).orElse(array) : array;
            return JsonField.newInstance((CharSequence)((CharSequence)entry.getKey()), (JsonValue)value);
        }).collect(JsonCollectors.fieldsToObject());
    }

    public static Acknowledgements fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return AcknowledgementsJsonParser.getInstance(new AcknowledgementJsonParser()).apply(jsonObject, dittoHeaders);
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObject acksJsonObject = this.acknowledgementsToJsonWithDisambiguation(schemaVersion, thePredicate, Acknowledgement::toJson);
        return JsonObject.newBuilder().set(CommandResponse.JsonFields.TYPE, (Object)this.getType(), predicate).set(JsonFields.ENTITY_ID, (Object)this.entityId.toString(), predicate).set(JsonFields.ENTITY_TYPE, (Object)this.getEntityType().toString(), predicate).set(JsonFields.STATUS_CODE, (Object)this.httpStatus.getCode(), predicate).set(JsonFields.ACKNOWLEDGEMENTS, (Object)acksJsonObject, predicate).build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acknowledgements that = (Acknowledgements)o;
        return this.entityId.equals(that.entityId) && this.acknowledgements.equals(that.acknowledgements) && this.httpStatus.equals(that.httpStatus) && this.dittoHeaders.equals(that.dittoHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.acknowledgements, this.httpStatus, this.dittoHeaders);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entityId=" + this.entityId + ", acknowledgements=" + this.acknowledgements + ", httpStatus=" + this.httpStatus + ", dittoHeaders=" + this.dittoHeaders + "]";
    }

    @Override
    public ResponseType getResponseType() {
        if (this.stream().allMatch(Acknowledgement::isSuccess)) {
            return ResponseType.RESPONSE;
        }
        return ResponseType.NACK;
    }

    @Override
    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public String getManifest() {
        return this.getType();
    }

    @Override
    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    @Override
    public String getResourceType() {
        return this.getType();
    }

    @FunctionalInterface
    private static interface AcknowledgementToJson {
        public JsonObject toJson(Acknowledgement var1, JsonSchemaVersion var2, Predicate<JsonField> var3);
    }

    @Immutable
    public static final class JsonFields {
        static final JsonFieldDefinition<String> ENTITY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"entityId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        static final JsonFieldDefinition<String> ENTITY_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"entityType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        static final JsonFieldDefinition<Integer> STATUS_CODE = JsonFactory.newIntFieldDefinition((CharSequence)"statusCode", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        static final JsonFieldDefinition<JsonObject> ACKNOWLEDGEMENTS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"acknowledgements", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

