/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.AcknowledgementException;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="acknowledgement:request.timeout")
@Immutable
public final class AcknowledgementRequestTimeoutException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:request.timeout";
    static final String MESSAGE_TEMPLATE = "The acknowledgement request reached the specified timeout of {0}ms.";
    static final String DEFAULT_DESCRIPTION = "Try increasing the timeout and make sure that the requested acknowledgement is sent back in time.";
    private static final long serialVersionUID = -6234783976182314364L;

    private AcknowledgementRequestTimeoutException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.REQUEST_TIMEOUT, dittoHeaders, message, description, cause, href);
    }

    public AcknowledgementRequestTimeoutException(Duration timeout) {
        this(DittoHeaders.empty(), AcknowledgementRequestTimeoutException.getMessage(timeout), DEFAULT_DESCRIPTION, null, null);
    }

    private static String getMessage(Duration timeout) {
        ConditionChecker.checkNotNull(timeout, "timeout");
        return MessageFormat.format(MESSAGE_TEMPLATE, timeout.toMillis());
    }

    public static Builder newBuilder(Duration timeout) {
        return new Builder(ConditionChecker.checkNotNull(timeout, "timeout"));
    }

    public static AcknowledgementRequestTimeoutException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementRequestTimeoutException> {
        private Builder() {
            this.description(AcknowledgementRequestTimeoutException.DEFAULT_DESCRIPTION);
        }

        private Builder(Duration timeout) {
            this();
            this.message(AcknowledgementRequestTimeoutException.getMessage(timeout));
        }

        @Override
        protected AcknowledgementRequestTimeoutException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementRequestTimeoutException(dittoHeaders, message, description, cause, href);
        }
    }
}

