/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.AcknowledgementException;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="acknowledgement:request.duplicate.correlation-id")
@Immutable
public final class AcknowledgementRequestDuplicateCorrelationIdException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:request.duplicate.correlation-id";
    static final String MESSAGE_TEMPLATE = "Correlation-id <{0}> for acknowledgement request was already used very recently.";
    static final String DEFAULT_DESCRIPTION = "Please provide unique correlation-ids when requesting acknowledgements, at least unique within at least several minutes.";
    private static final long serialVersionUID = -8902347821367123893L;

    private AcknowledgementRequestDuplicateCorrelationIdException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.CONFLICT, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String correlationId) {
        return new Builder(correlationId);
    }

    public static AcknowledgementRequestDuplicateCorrelationIdException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementRequestDuplicateCorrelationIdException> {
        private Builder(String correlationId) {
            this.message(MessageFormat.format(AcknowledgementRequestDuplicateCorrelationIdException.MESSAGE_TEMPLATE, correlationId));
            this.description(AcknowledgementRequestDuplicateCorrelationIdException.DEFAULT_DESCRIPTION);
        }

        private Builder() {
            this.description(AcknowledgementRequestDuplicateCorrelationIdException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AcknowledgementRequestDuplicateCorrelationIdException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementRequestDuplicateCorrelationIdException(dittoHeaders, message, description, cause, href);
        }
    }
}

