/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.text.MessageFormat;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabelInvalidException;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.common.HttpStatusCodeOutOfRangeException;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.acks.Acknowledgement;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;

@Immutable
final class AcknowledgementJsonParser
implements Function<JsonObject, Acknowledgement> {
    AcknowledgementJsonParser() {
    }

    @Override
    public Acknowledgement apply(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        AcknowledgementLabel label = AcknowledgementJsonParser.tryToGetAcknowledgementLabel(jsonObject);
        EntityId entityId = this.getEntityId(jsonObject);
        HttpStatus httpStatus = AcknowledgementJsonParser.getHttpStatus(jsonObject);
        DittoHeaders dittoHeaders = AcknowledgementJsonParser.getDittoHeaders(jsonObject);
        JsonValue payload = AcknowledgementJsonParser.getPayloadOrNull(jsonObject);
        return Acknowledgement.of(label, entityId, httpStatus, dittoHeaders, payload);
    }

    private static AcknowledgementLabel tryToGetAcknowledgementLabel(JsonObject jsonObject) {
        try {
            return AcknowledgementJsonParser.getAcknowledgementLabel(jsonObject);
        }
        catch (AcknowledgementLabelInvalidException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).description((String)e.getDescription().orElse(null)).cause((Throwable)e).build();
        }
    }

    private static AcknowledgementLabel getAcknowledgementLabel(JsonObject jsonObject) {
        return AcknowledgementLabel.of((CharSequence)jsonObject.getValueOrThrow(Acknowledgement.JsonFields.LABEL));
    }

    private EntityId getEntityId(JsonObject jsonObject) {
        EntityType entityType = EntityType.of((CharSequence)jsonObject.getValueOrThrow(Acknowledgement.JsonFields.ENTITY_TYPE));
        String entityId = (String)jsonObject.getValueOrThrow(Acknowledgement.JsonFields.ENTITY_ID);
        return this.tryToGetEntityId(entityType, entityId);
    }

    public EntityId tryToGetEntityId(EntityType entityType, CharSequence entityIdValue) {
        try {
            return EntityId.of(entityType, entityIdValue);
        }
        catch (DittoRuntimeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).description((String)e.getDescription().orElse(null)).cause((Throwable)e).build();
        }
        catch (RuntimeException e) {
            String message = MessageFormat.format("Entity ID <{0}> is invalid!", entityIdValue);
            JsonParseException jsonParseException = new JsonParseException(message);
            jsonParseException.initCause((Throwable)e);
            throw jsonParseException;
        }
    }

    private static HttpStatus getHttpStatus(JsonObject jsonObject) {
        Integer statusCodeValue = (Integer)jsonObject.getValueOrThrow(Acknowledgement.JsonFields.STATUS_CODE);
        try {
            return HttpStatus.getInstance(statusCodeValue);
        }
        catch (HttpStatusCodeOutOfRangeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(e.getMessage()).cause((Throwable)e).build();
        }
    }

    private static DittoHeaders getDittoHeaders(JsonObject jsonObject) {
        JsonObject dittoHeadersJsonObject = (JsonObject)jsonObject.getValueOrThrow(Acknowledgement.JsonFields.DITTO_HEADERS);
        return DittoHeaders.newBuilder(dittoHeadersJsonObject).build();
    }

    @Nullable
    private static JsonValue getPayloadOrNull(JsonObject jsonObject) {
        return jsonObject.getValue(Acknowledgement.JsonFields.PAYLOAD).filter(value -> !value.isNull()).orElse(null);
    }
}

