/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.acks.AcknowledgementException;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="acknowledgement:correlation-id.missing")
@Immutable
public final class AcknowledgementCorrelationIdMissingException
extends DittoRuntimeException
implements AcknowledgementException {
    public static final String ERROR_CODE = "acknowledgement:correlation-id.missing";
    static final String DEFAULT_MESSAGE = "Correlation-id header for acknowledgement is missing.";
    static final String DEFAULT_DESCRIPTION = "Please provide the mandatory header 'correlation-id' as part of your acknowledgement";
    private static final long serialVersionUID = 5893456783453452366L;

    private AcknowledgementCorrelationIdMissingException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AcknowledgementCorrelationIdMissingException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AcknowledgementCorrelationIdMissingException> {
        private Builder() {
            this.message(AcknowledgementCorrelationIdMissingException.DEFAULT_MESSAGE);
            this.description(AcknowledgementCorrelationIdMissingException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected AcknowledgementCorrelationIdMissingException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AcknowledgementCorrelationIdMissingException(dittoHeaders, message, description, cause, href);
        }
    }
}

