/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals.acks;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.acks.AcknowledgementLabel;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.common.ResponseType;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.entity.type.WithEntityType;
import org.eclipse.ditto.base.model.headers.DittoHeaderDefinition;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableCommandResponse;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.base.model.signals.SignalWithEntityId;
import org.eclipse.ditto.base.model.signals.WithOptionalEntity;
import org.eclipse.ditto.base.model.signals.acks.AcknowledgementJsonParser;
import org.eclipse.ditto.base.model.signals.commands.CommandResponse;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;

@JsonParsableCommandResponse(type="acknowledgement")
@Immutable
public final class Acknowledgement
implements CommandResponse<Acknowledgement>,
WithOptionalEntity,
WithEntityType,
SignalWithEntityId<Acknowledgement> {
    public static final String TYPE = "acknowledgement";
    private static final String TRUE_STRING = Boolean.TRUE.toString();
    private final AcknowledgementLabel label;
    private final EntityId entityId;
    private final HttpStatus httpStatus;
    @Nullable
    private final JsonValue payload;
    private final DittoHeaders dittoHeaders;
    private final boolean isWeak;

    private Acknowledgement(AcknowledgementLabel label, EntityId entityId, HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable JsonValue payload) {
        this.label = ConditionChecker.checkNotNull(label, "label");
        this.entityId = ConditionChecker.checkNotNull(entityId, "entityId");
        this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        DittoHeadersBuilder<?, ?> dittoHeadersBuilder = ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders").isResponseRequired() ? dittoHeaders.toBuilder().responseRequired(false) : dittoHeaders.toBuilder();
        this.dittoHeaders = dittoHeadersBuilder.removeHeader(DittoHeaderDefinition.REQUESTED_ACKS.getKey()).build();
        this.payload = payload;
        this.isWeak = TRUE_STRING.equalsIgnoreCase((String)this.dittoHeaders.get(DittoHeaderDefinition.WEAK_ACK.getKey()));
    }

    public static Acknowledgement of(AcknowledgementLabel label, EntityId entityId, HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable JsonValue payload) {
        return new Acknowledgement(label, entityId, httpStatus, dittoHeaders, payload);
    }

    public static Acknowledgement weak(AcknowledgementLabel label, EntityId entityId, DittoHeaders dittoHeaders, @Nullable JsonValue payload) {
        Object weakAckHeaders = dittoHeaders.toBuilder().putHeader(DittoHeaderDefinition.WEAK_ACK.getKey(), Boolean.TRUE.toString()).build();
        return Acknowledgement.of(label, entityId, HttpStatus.OK, weakAckHeaders, payload);
    }

    public static Acknowledgement of(AcknowledgementLabel label, EntityId entityId, HttpStatus httpStatus, DittoHeaders dittoHeaders) {
        return Acknowledgement.of(label, entityId, httpStatus, dittoHeaders, null);
    }

    public AcknowledgementLabel getLabel() {
        return this.label;
    }

    @Override
    public EntityId getEntityId() {
        return this.entityId;
    }

    public boolean isSuccess() {
        return this.httpStatus.isSuccess();
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public boolean isTimeout() {
        return HttpStatus.REQUEST_TIMEOUT.equals(this.httpStatus);
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.payload);
    }

    public Acknowledgement setEntity(@Nullable JsonValue payload) {
        if (payload != null) {
            return Acknowledgement.of(this.label, this.entityId, this.httpStatus, this.dittoHeaders, payload);
        }
        return Acknowledgement.of(this.label, this.entityId, this.httpStatus, this.dittoHeaders, null);
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public Acknowledgement setDittoHeaders(DittoHeaders dittoHeaders) {
        return Acknowledgement.of(this.label, this.entityId, this.httpStatus, dittoHeaders, this.payload);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityId.getEntityType();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static Acknowledgement fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new AcknowledgementJsonParser().apply(jsonObject);
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(CommandResponse.JsonFields.TYPE, (Object)this.getType(), predicate);
        jsonObjectBuilder.set(JsonFields.LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JsonFields.ENTITY_ID, (Object)this.entityId.toString(), predicate);
        jsonObjectBuilder.set(JsonFields.ENTITY_TYPE, (Object)this.getEntityType().toString(), predicate);
        jsonObjectBuilder.set(JsonFields.STATUS_CODE, (Object)this.httpStatus.getCode(), predicate);
        if (null != this.payload) {
            jsonObjectBuilder.set(JsonFields.PAYLOAD, (Object)this.payload, predicate);
        }
        jsonObjectBuilder.set(JsonFields.DITTO_HEADERS, (Object)((JsonObject)this.dittoHeaders.toJson()), predicate);
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acknowledgement that = (Acknowledgement)o;
        return this.httpStatus.equals(that.httpStatus) && this.label.equals(that.label) && this.entityId.equals(that.entityId) && Objects.equals(this.payload, that.payload) && this.dittoHeaders.equals(that.dittoHeaders) && this.isWeak == that.isWeak;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.entityId, this.httpStatus, this.payload, this.dittoHeaders, this.isWeak);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [label=" + this.label + ", entityId=" + this.entityId + ", httpStatus=" + this.httpStatus + ", payload=" + this.payload + ", dittoHeaders=" + this.dittoHeaders + ", isWeak=" + this.isWeak + "]";
    }

    @Override
    public ResponseType getResponseType() {
        if (this.isSuccess()) {
            return ResponseType.RESPONSE;
        }
        return ResponseType.NACK;
    }

    @Override
    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public String getManifest() {
        return this.getType();
    }

    @Override
    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    @Override
    public String getResourceType() {
        return this.getType();
    }

    public static final class JsonFields {
        public static final JsonFieldDefinition<String> LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ENTITY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"entityId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ENTITY_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"entityType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Integer> STATUS_CODE = JsonFactory.newIntFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonValue> PAYLOAD = JsonFactory.newJsonValueFieldDefinition((CharSequence)"payload", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> DITTO_HEADERS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"headers", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

