/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

@JsonParsableException(errorCode="signal.unsupported")
@Immutable
public final class UnsupportedSignalException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "signal.unsupported";
    static final String MESSAGE_TEMPLATE = "The provided signal ''{0}'' is not supported.";
    static final String DEFAULT_DESCRIPTION = "Check if you specified the correct resource/path and payload.";
    private static final long serialVersionUID = -8102351974097361762L;

    private UnsupportedSignalException(HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, httpStatus, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String signal) {
        return new Builder(ConditionChecker.checkNotNull(signal, "signal"));
    }

    public static UnsupportedSignalException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static UnsupportedSignalException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        Builder builder = new Builder();
        builder.dittoHeaders(ConditionChecker.checkNotNull(dittoHeaders, "dittoHeaders"));
        try {
            builder.message((String)jsonObject.getValueOrThrow(DittoRuntimeException.JsonFields.MESSAGE));
            jsonObject.getValue(DittoRuntimeException.JsonFields.STATUS).flatMap(HttpStatus::tryGetInstance).ifPresent(builder::httpStatus);
            jsonObject.getValue(DittoRuntimeException.JsonFields.DESCRIPTION).ifPresent(builder::description);
            jsonObject.getValue(DittoRuntimeException.JsonFields.HREF).map(URI::create).ifPresent(builder::href);
        }
        catch (Exception e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize JSON object to a {0}: {1}", UnsupportedSignalException.class.getSimpleName(), e.getMessage())).cause((Throwable)e).build();
        }
        return (UnsupportedSignalException)builder.build();
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().httpStatus(this.getHttpStatus()).message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnsupportedSignalException> {
        private HttpStatus httpStatus = HttpStatus.BAD_REQUEST;

        private Builder() {
            this.description(UnsupportedSignalException.DEFAULT_DESCRIPTION);
        }

        private Builder(String signal) {
            this();
            this.message(MessageFormat.format(UnsupportedSignalException.MESSAGE_TEMPLATE, signal));
        }

        public Builder httpStatus(HttpStatus httpStatus) {
            this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
            if (!httpStatus.isClientError() && !httpStatus.isServerError()) {
                String pattern = "Category of <{0}> is neither client error nor server error.";
                throw new IllegalArgumentException(MessageFormat.format("Category of <{0}> is neither client error nor server error.", httpStatus));
            }
            return this;
        }

        @Override
        protected UnsupportedSignalException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnsupportedSignalException(this.httpStatus, dittoHeaders, message, description, cause, href);
        }
    }
}

