/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.net.URI;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="unknown")
final class UnknownDittoRuntimeException
extends DittoRuntimeException
implements GeneralException {
    public static final String FALLBACK_ERROR_CODE = "unknown";

    protected UnknownDittoRuntimeException(String errorCode, HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(errorCode, httpStatus, dittoHeaders, message, description, cause, href);
    }

    public static UnknownDittoRuntimeException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        HttpStatus httpStatus = UnknownDittoRuntimeException.getHttpStatus(jsonObject).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
        String errorCode = jsonObject.getValue(DittoRuntimeException.JsonFields.ERROR_CODE).orElse(FALLBACK_ERROR_CODE);
        String errorMessage = jsonObject.getValue(DittoRuntimeException.JsonFields.MESSAGE).orElse("An unknown error occurred");
        String errorDescription = jsonObject.getValue(DittoRuntimeException.JsonFields.DESCRIPTION).orElse("");
        URI href = DittoRuntimeException.getHref(jsonObject).orElse(null);
        return new UnknownDittoRuntimeException(errorCode, httpStatus, dittoHeaders, errorMessage, errorDescription, null, href);
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder(this.getErrorCode(), this.getHttpStatus()).message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    public static class Builder
    extends DittoRuntimeExceptionBuilder<UnknownDittoRuntimeException> {
        private final String errorCode;
        private final HttpStatus httpStatus;

        private Builder(String errorCode, HttpStatus httpStatus) {
            this.errorCode = errorCode;
            this.httpStatus = httpStatus;
        }

        @Override
        protected UnknownDittoRuntimeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnknownDittoRuntimeException(this.errorCode, this.httpStatus, dittoHeaders, message, description, cause, href);
        }
    }
}

