/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersSettable;
import org.eclipse.ditto.base.model.headers.LiveChannelTimeoutStrategy;
import org.eclipse.ditto.base.model.headers.WithDittoHeaders;
import org.eclipse.ditto.base.model.headers.WithManifest;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.base.model.signals.WithName;
import org.eclipse.ditto.base.model.signals.WithResource;
import org.eclipse.ditto.base.model.signals.WithType;
import org.eclipse.ditto.base.model.signals.commands.Command;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;

public interface Signal<T extends Signal<T>>
extends Jsonifiable.WithPredicate<JsonObject, JsonField>,
DittoHeadersSettable<T>,
WithManifest,
WithType,
WithName,
WithResource {
    public static final String CHANNEL_LIVE = "live";
    public static final String CHANNEL_TWIN = "twin";

    @Override
    default public String getName() {
        return this.getType().contains(":") ? this.getType().split(":")[1] : this.getType();
    }

    public static boolean isChannelLive(@Nullable WithDittoHeaders signal) {
        boolean result;
        if (null != signal) {
            DittoHeaders dittoHeaders = signal.getDittoHeaders();
            result = dittoHeaders.getChannel().filter(CHANNEL_LIVE::equals).isPresent();
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isChannelSmart(@Nullable Signal<?> signal) {
        boolean result;
        if (null != signal && Command.isThingCommand(signal)) {
            Command thingCommand = (Command)signal;
            if (thingCommand.getCategory() == Command.Category.QUERY) {
                DittoHeaders headers = thingCommand.getDittoHeaders();
                result = Signal.isChannelLive(thingCommand) ? LiveChannelTimeoutStrategy.USE_TWIN == headers.getLiveChannelTimeoutStrategy().orElse(LiveChannelTimeoutStrategy.FAIL) : headers.getLiveChannelCondition().isPresent();
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }
}

