/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.entity.id.EntityIdJsonDeserializer;
import org.eclipse.ditto.base.model.entity.id.WithEntityId;
import org.eclipse.ditto.base.model.entity.type.EntityTypeJsonDeserializer;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersSettable;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;

public final class ShardedMessageEnvelope
implements Jsonifiable<JsonObject>,
DittoHeadersSettable<ShardedMessageEnvelope>,
WithEntityId {
    public static final JsonFieldDefinition<String> JSON_ID = JsonFactory.newStringFieldDefinition((CharSequence)"id", (JsonFieldMarker[])new JsonFieldMarker[0]);
    public static final JsonFieldDefinition<String> JSON_ID_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"entityType", (JsonFieldMarker[])new JsonFieldMarker[0]);
    public static final JsonFieldDefinition<String> JSON_TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[0]);
    public static final JsonFieldDefinition<JsonObject> JSON_MESSAGE = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[0]);
    public static final JsonFieldDefinition<JsonObject> JSON_DITTO_HEADERS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"dittoHeaders", (JsonFieldMarker[])new JsonFieldMarker[0]);
    private final EntityId id;
    private final String type;
    private final JsonObject message;
    private final DittoHeaders dittoHeaders;

    private ShardedMessageEnvelope(EntityId id, String type, JsonObject message, DittoHeaders dittoHeaders) {
        this.id = ConditionChecker.checkNotNull(id, "Message ID");
        this.type = ConditionChecker.checkNotNull(type, "Type");
        this.message = ConditionChecker.checkNotNull(message, "Message");
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "Command Headers");
    }

    public static ShardedMessageEnvelope of(EntityId id, String type, JsonObject message, DittoHeaders dittoHeaders) {
        return new ShardedMessageEnvelope(id, type, message, dittoHeaders);
    }

    public static ShardedMessageEnvelope fromJson(JsonObject jsonObject) {
        return ShardedMessageEnvelope.of(ShardedMessageEnvelope.deserializeEntityId(jsonObject), (String)jsonObject.getValueOrThrow(JSON_TYPE), (JsonObject)jsonObject.getValueOrThrow(JSON_MESSAGE), ShardedMessageEnvelope.deserializeDittoHeaders(jsonObject));
    }

    private static EntityId deserializeEntityId(JsonObject jsonObject) {
        return EntityIdJsonDeserializer.deserializeEntityId(jsonObject, JSON_ID, EntityTypeJsonDeserializer.deserializeEntityType(jsonObject, JSON_ID_TYPE));
    }

    private static DittoHeaders deserializeDittoHeaders(JsonObject jsonObject) {
        JsonFieldDefinition<JsonObject> fieldDefinition = JSON_DITTO_HEADERS;
        JsonObject jsonDittoHeaders = (JsonObject)jsonObject.getValueOrThrow(fieldDefinition);
        try {
            return DittoHeaders.newBuilder(jsonDittoHeaders).build();
        }
        catch (RuntimeException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize value of key <{0}> as {1}: {2}", fieldDefinition.getPointer(), DittoHeaders.class.getSimpleName(), e.getMessage())).cause((Throwable)e).build();
        }
    }

    @Override
    public EntityId getEntityId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public JsonObject getMessage() {
        return this.message;
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public ShardedMessageEnvelope setDittoHeaders(DittoHeaders dittoHeaders) {
        return ShardedMessageEnvelope.of(this.id, this.type, this.message, dittoHeaders);
    }

    @Override
    public JsonObject toJson() {
        return JsonObject.newBuilder().set(JSON_ID_TYPE, (Object)this.id.getEntityType().toString()).set(JSON_ID, (Object)String.valueOf(this.id)).set(JSON_TYPE, (Object)this.type).set(JSON_MESSAGE, (Object)this.message).set(JSON_DITTO_HEADERS, (Object)((JsonObject)this.dittoHeaders.toJson())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardedMessageEnvelope that = (ShardedMessageEnvelope)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.dittoHeaders, that.dittoHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.message, this.dittoHeaders);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", type=" + this.type + ", message=" + this.message + ", dittoHeaders=" + this.dittoHeaders + "]";
    }
}

