/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.base.model.exceptions.GeneralException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.json.JsonObject;

@JsonParsableException(errorCode="json.type.notparsable")
@Immutable
public final class JsonTypeNotParsableException
extends DittoRuntimeException
implements GeneralException {
    public static final String ERROR_CODE = "json.type.notparsable";
    private static final String MESSAGE_TEMPLATE = "The JSON type ''{0}'' is not supported by registry ''{1}''.";
    private static final String DEFAULT_DESCRIPTION = "Check if you sent the JSON with the correct type.";
    private static final long serialVersionUID = 1764112162089631698L;

    private JsonTypeNotParsableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String type, String registryName) {
        return new Builder(type, registryName);
    }

    public static JsonTypeNotParsableException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static JsonTypeNotParsableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<JsonTypeNotParsableException> {
        private Builder() {
            this.description(JsonTypeNotParsableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String type, String registryName) {
            this();
            this.message(MessageFormat.format(JsonTypeNotParsableException.MESSAGE_TEMPLATE, type, registryName));
        }

        @Override
        protected JsonTypeNotParsableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new JsonTypeNotParsableException(dittoHeaders, message, description, cause, href);
        }
    }
}

