/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.signals.AbstractAnnotationBasedJsonParsableFactory;
import org.eclipse.ditto.base.model.signals.AbstractGlobalJsonParsableRegistry;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.JsonParsable;
import org.eclipse.ditto.base.model.signals.JsonTypeNotParsableException;
import org.eclipse.ditto.base.model.signals.UnknownDittoRuntimeException;
import org.eclipse.ditto.json.JsonFieldSelectorInvalidException;
import org.eclipse.ditto.json.JsonKeyInvalidException;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointerInvalidException;

@Immutable
public final class GlobalErrorRegistry
extends AbstractGlobalJsonParsableRegistry<DittoRuntimeException, JsonParsableException>
implements ErrorRegistry<DittoRuntimeException> {
    private static final GlobalErrorRegistry INSTANCE = new GlobalErrorRegistry(new DittoJsonExceptionRegistry());

    private GlobalErrorRegistry(DittoJsonExceptionRegistry dittoJsonExceptionRegistry) {
        super(DittoRuntimeException.class, JsonParsableException.class, new ExceptionParsingStrategyFactory(), dittoJsonExceptionRegistry.getDittoJsonParseRegistries());
    }

    public static GlobalErrorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    protected String resolveType(JsonObject jsonObject) {
        return (String)jsonObject.getValue(DittoRuntimeException.JsonFields.ERROR_CODE).orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)DittoRuntimeException.JsonFields.ERROR_CODE.getPointer().toString()).build());
    }

    @Override
    public DittoRuntimeException parse(String jsonString, DittoHeaders dittoHeaders) {
        try {
            return (DittoRuntimeException)super.parse(jsonString, dittoHeaders);
        }
        catch (JsonTypeNotParsableException e) {
            return UnknownDittoRuntimeException.fromJson(JsonObject.of((String)jsonString), dittoHeaders);
        }
    }

    @Override
    public DittoRuntimeException parse(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        try {
            return (DittoRuntimeException)super.parse(jsonObject, dittoHeaders);
        }
        catch (JsonTypeNotParsableException e) {
            return UnknownDittoRuntimeException.fromJson(jsonObject, dittoHeaders);
        }
    }

    @Override
    public DittoRuntimeException parse(JsonObject jsonObject, DittoHeaders dittoHeaders, JsonParsable.ParseInnerJson parseInnerJson) {
        try {
            return (DittoRuntimeException)super.parse(jsonObject, dittoHeaders, parseInnerJson);
        }
        catch (JsonTypeNotParsableException e) {
            return UnknownDittoRuntimeException.fromJson(jsonObject, dittoHeaders);
        }
    }

    private static final class ExceptionParsingStrategyFactory
    extends AbstractAnnotationBasedJsonParsableFactory<DittoRuntimeException, JsonParsableException> {
        private ExceptionParsingStrategyFactory() {
        }

        @Override
        protected String getKeyFor(JsonParsableException annotation) {
            return annotation.errorCode();
        }

        @Override
        protected String getMethodNameFor(JsonParsableException annotation) {
            return annotation.method();
        }
    }

    private static final class DittoJsonExceptionRegistry {
        private final Map<String, JsonParsable<DittoRuntimeException>> dittoJsonParseRegistries = new HashMap<String, JsonParsable<DittoRuntimeException>>();

        private DittoJsonExceptionRegistry() {
            this.dittoJsonParseRegistries.put("json.invalid", (jsonObject, dittoHeaders) -> new DittoJsonException((RuntimeException)JsonParseException.newBuilder().message(DittoJsonExceptionRegistry.getMessage(jsonObject)).description(DittoJsonExceptionRegistry.getDescription(jsonObject)).build(), dittoHeaders));
            this.dittoJsonParseRegistries.put("json.field.missing", (jsonObject, dittoHeaders) -> new DittoJsonException((RuntimeException)JsonMissingFieldException.newBuilder().message(DittoJsonExceptionRegistry.getMessage(jsonObject)).description(DittoJsonExceptionRegistry.getDescription(jsonObject)).build(), dittoHeaders));
            this.dittoJsonParseRegistries.put("json.fieldselector.invalid", (jsonObject, dittoHeaders) -> new DittoJsonException((RuntimeException)JsonFieldSelectorInvalidException.newBuilder().message(DittoJsonExceptionRegistry.getMessage(jsonObject)).description(DittoJsonExceptionRegistry.getDescription(jsonObject)).build(), dittoHeaders));
            this.dittoJsonParseRegistries.put("json.pointer.invalid", (jsonObject, dittoHeaders) -> new DittoJsonException((RuntimeException)JsonPointerInvalidException.newBuilder().message(DittoJsonExceptionRegistry.getMessage(jsonObject)).description(DittoJsonExceptionRegistry.getDescription(jsonObject)).build(), dittoHeaders));
            this.dittoJsonParseRegistries.put("json.key.invalid", (jsonObject, dittoHeaders) -> new DittoJsonException((RuntimeException)JsonKeyInvalidException.newBuilder().message(DittoJsonExceptionRegistry.getMessage(jsonObject)).description(DittoJsonExceptionRegistry.getDescription(jsonObject)).build(), dittoHeaders));
        }

        @Nullable
        private static String getMessage(JsonObject jsonObject) {
            return jsonObject.getValue(DittoRuntimeException.JsonFields.MESSAGE).orElse(null);
        }

        @Nullable
        private static String getDescription(JsonObject jsonObject) {
            return jsonObject.getValue(DittoRuntimeException.JsonFields.DESCRIPTION).orElse(null);
        }

        private Map<String, JsonParsable<DittoRuntimeException>> getDittoJsonParseRegistries() {
            return this.dittoJsonParseRegistries;
        }
    }
}

