/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.UnsupportedSignalException;

public final class FeatureToggle {
    public static final String MERGE_THINGS_ENABLED = "ditto.devops.feature.merge-things-enabled";
    public static final String WOT_INTEGRATION_ENABLED = "ditto.devops.feature.wot-integration-enabled";
    private static final boolean IS_MERGE_THINGS_ENABLED = FeatureToggle.resolveProperty("ditto.devops.feature.merge-things-enabled");
    private static final boolean IS_WOT_INTEGRATION_ENABLED = FeatureToggle.resolveProperty("ditto.devops.feature.wot-integration-enabled");

    private static boolean resolveProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName, Boolean.TRUE.toString());
        return !Boolean.FALSE.toString().equalsIgnoreCase(propertyValue);
    }

    private FeatureToggle() {
        throw new AssertionError();
    }

    public static DittoHeaders checkMergeFeatureEnabled(String signal, DittoHeaders dittoHeaders) {
        if (!IS_MERGE_THINGS_ENABLED) {
            throw (UnsupportedSignalException)UnsupportedSignalException.newBuilder(signal).dittoHeaders(dittoHeaders).build();
        }
        return dittoHeaders;
    }

    public static DittoHeaders checkWotIntegrationFeatureEnabled(String signal, DittoHeaders dittoHeaders) {
        if (!FeatureToggle.isWotIntegrationFeatureEnabled()) {
            throw (UnsupportedSignalException)UnsupportedSignalException.newBuilder(signal).dittoHeaders(dittoHeaders).build();
        }
        return dittoHeaders;
    }

    public static boolean isWotIntegrationFeatureEnabled() {
        return IS_WOT_INTEGRATION_ENABLED;
    }
}

