/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;

public final class DateTimeUtil {
    public static final DateTimeFormatter OFFSET_DATE_TIME_EXPANDED = DateTimeUtil.appendOffsets("uuuu-MM-dd'T'HH[:mm[:ss[.SSS]]]", "+HH:mm", "+HH");
    public static final DateTimeFormatter OFFSET_DATE_TIME_BASIC = DateTimeUtil.appendOffsets("uuuuMMdd'T'HH[mm[ss[.SSS]]]", "+HHmm", "+HH");
    public static final DateTimeFormatter OFFSET_DATE_TIME = DateTimeUtil.caseInsensitiveAnd(DateTimeUtil.or(OFFSET_DATE_TIME_BASIC, OFFSET_DATE_TIME_EXPANDED));

    public static OffsetDateTime parseOffsetDateTime(String timestamp) {
        return OffsetDateTime.parse(timestamp, OFFSET_DATE_TIME);
    }

    private static DateTimeFormatter appendOffsets(String dateTimeFormat, String ... offsetPatterns) {
        DateTimeFormatter dateTimePart = DateTimeFormatter.ofPattern(dateTimeFormat);
        DateTimeFormatter[] formatters = (DateTimeFormatter[])Arrays.stream(offsetPatterns).map(offsetPattern -> {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            builder.append(dateTimePart);
            builder.appendOffset((String)offsetPattern, "Z");
            return builder.toFormatter();
        }).toArray(DateTimeFormatter[]::new);
        return DateTimeUtil.or(formatters);
    }

    private static DateTimeFormatter or(DateTimeFormatter ... alternatives) {
        DateTimeFormatterBuilder prefix = new DateTimeFormatterBuilder();
        for (DateTimeFormatter alternative : alternatives) {
            prefix.optionalStart().append(alternative).optionalEnd();
        }
        return prefix.toFormatter();
    }

    private static DateTimeFormatter and(DateTimeFormatter ... formatters) {
        DateTimeFormatterBuilder prefix = new DateTimeFormatterBuilder();
        for (DateTimeFormatter formatter : formatters) {
            prefix.append(formatter);
        }
        return prefix.toFormatter();
    }

    private static DateTimeFormatter caseInsensitiveAnd(DateTimeFormatter ... formatters) {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeUtil.and(formatters)).toFormatter();
    }

    private DateTimeUtil() {
        throw new AssertionError();
    }
}

