/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.DeserializationStrategyNotFoundError;
import org.eclipse.ditto.base.model.signals.JsonParsable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonRuntimeException;

final class AnnotationBasedJsonParsable<T>
implements JsonParsable<T> {
    private static final Class<?> JSON_OBJECT_PARAMETER = JsonObject.class;
    private static final Class<?> DITTO_HEADERS_PARAMETER = DittoHeaders.class;
    private static final Class<?> PARSE_INNER_JSON_PARAMETER = JsonParsable.ParseInnerJson.class;
    private final String key;
    private final Method parseMethod;

    AnnotationBasedJsonParsable(String key, Class<? extends T> parsedClass, String parsingMethodName) {
        this.key = key;
        try {
            this.parseMethod = AnnotationBasedJsonParsable.getParseMethod(parsedClass, parsingMethodName);
            Class<?> returnType = this.parseMethod.getReturnType();
            if (!parsedClass.isAssignableFrom(returnType)) {
                throw new IllegalArgumentException(String.format("Parse method is invalid. Return type <%s> of parse method must be assignable to parsed class: <%s>.", returnType.getSimpleName(), parsedClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            throw new DeserializationStrategyNotFoundError(parsedClass, (Throwable)e);
        }
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public T parse(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        try {
            return (T)this.parseMethod.invoke(null, jsonObject, dittoHeaders);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw this.buildDittoJsonException(e, jsonObject, dittoHeaders);
        }
        catch (InvocationTargetException e) {
            throw this.fromInvocationTargetException(e, jsonObject, dittoHeaders);
        }
    }

    @Override
    public T parse(JsonObject jsonObject, DittoHeaders dittoHeaders, JsonParsable.ParseInnerJson parseInnerJson) {
        try {
            if (this.parseMethod.getParameterCount() == 3) {
                return (T)this.parseMethod.invoke(null, jsonObject, dittoHeaders, parseInnerJson);
            }
            return (T)this.parseMethod.invoke(null, jsonObject, dittoHeaders);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw this.buildDittoJsonException(e, jsonObject, dittoHeaders);
        }
        catch (InvocationTargetException e) {
            throw this.fromInvocationTargetException(e, jsonObject, dittoHeaders);
        }
    }

    private DittoJsonException fromInvocationTargetException(InvocationTargetException e, JsonObject jsonObject, DittoHeaders dittoHeaders) {
        Throwable targetException = e.getTargetException();
        if (targetException instanceof DittoRuntimeException) {
            throw (DittoRuntimeException)targetException;
        }
        if (targetException instanceof JsonRuntimeException) {
            throw new DittoJsonException((RuntimeException)((Object)((JsonRuntimeException)targetException)), dittoHeaders);
        }
        return this.buildDittoJsonException(targetException, jsonObject, dittoHeaders);
    }

    private DittoJsonException buildDittoJsonException(Throwable cause, JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return new DittoJsonException((RuntimeException)JsonParseException.newBuilder().message(String.format("Error during parsing json: <%s>", jsonObject.toString())).cause(cause).build(), dittoHeaders);
    }

    private static Method getParseMethod(Class<?> parsedClass, String methodName) throws NoSuchMethodException {
        try {
            return parsedClass.getMethod(methodName, JSON_OBJECT_PARAMETER, DITTO_HEADERS_PARAMETER, PARSE_INNER_JSON_PARAMETER);
        }
        catch (NoSuchMethodException e) {
            return parsedClass.getMethod(methodName, JSON_OBJECT_PARAMETER, DITTO_HEADERS_PARAMETER);
        }
    }
}

