/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoJsonException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.base.model.signals.JsonParsable;
import org.eclipse.ditto.base.model.signals.JsonParsableRegistry;
import org.eclipse.ditto.base.model.signals.JsonTypeNotParsableException;
import org.eclipse.ditto.json.JsonExceptionBuilder;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonRuntimeException;

@Immutable
public abstract class AbstractJsonParsableRegistry<T>
implements JsonParsableRegistry<T> {
    private static final JsonParsable.ParseInnerJson UNSUPPORTED = new ParseInnerJsonUnsupported();
    private final Map<String, JsonParsable<T>> parseStrategies;

    protected AbstractJsonParsableRegistry(Map<String, JsonParsable<T>> parseStrategies) {
        ConditionChecker.checkNotNull(parseStrategies, "parse strategies");
        this.parseStrategies = Collections.unmodifiableMap(new HashMap<String, JsonParsable<T>>(parseStrategies));
    }

    @Override
    public Set<String> getTypes() {
        return this.parseStrategies.keySet();
    }

    @Override
    public T parse(String jsonString, DittoHeaders dittoHeaders) {
        return (T)DittoJsonException.wrapJsonRuntimeException(jsonString, dittoHeaders, this::fromJson);
    }

    @Override
    public T parse(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (T)DittoJsonException.wrapJsonRuntimeException(jsonObject, dittoHeaders, this::fromJson);
    }

    @Override
    public T parse(JsonObject jsonObject, DittoHeaders dittoHeaders, JsonParsable.ParseInnerJson parseInnerJson) {
        return (T)DittoJsonException.wrapJsonRuntimeException(jsonObject, dittoHeaders, (object, headers) -> this.fromJson((JsonObject)object, (DittoHeaders)headers, parseInnerJson));
    }

    private T fromJson(String jsonString, DittoHeaders dittoHeaders) {
        JsonObject jsonObject = JsonFactory.newObject((String)jsonString);
        return this.fromJson(jsonObject, dittoHeaders, UNSUPPORTED);
    }

    private T fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return this.fromJson(jsonObject, dittoHeaders, UNSUPPORTED);
    }

    private T fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders, JsonParsable.ParseInnerJson inner) {
        String type = this.resolveType(jsonObject);
        JsonParsable<T> jsonObjectParsable = this.parseStrategies.get(type);
        if (null != jsonObjectParsable) {
            try {
                return jsonObjectParsable.parse(jsonObject, dittoHeaders, inner);
            }
            catch (JsonRuntimeException jre) {
                JsonExceptionBuilder builder = JsonRuntimeException.newBuilder((String)jre.getErrorCode()).message("Error when parsing Json type '" + type + "': " + jre.getMessage()).cause(jre.getCause());
                jre.getDescription().ifPresent(arg_0 -> ((JsonExceptionBuilder)builder).description(arg_0));
                jre.getHref().ifPresent(arg_0 -> ((JsonExceptionBuilder)builder).href(arg_0));
                throw (JsonRuntimeException)builder.build();
            }
        }
        throw (JsonTypeNotParsableException)JsonTypeNotParsableException.newBuilder(type, this.getClass().getSimpleName()).dittoHeaders(dittoHeaders).build();
    }

    protected abstract String resolveType(JsonObject var1);

    private static final class ParseInnerJsonUnsupported
    implements JsonParsable.ParseInnerJson {
        private ParseInnerJsonUnsupported() {
        }

        @Override
        public Jsonifiable<?> parseInnerJson(JsonObject jsonObject) throws NotSerializableException {
            throw new UnsupportedOperationException();
        }
    }
}

