/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.base.model.signals;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.atteo.classindex.ClassIndex;
import org.eclipse.ditto.base.model.signals.AbstractAnnotationBasedJsonParsableFactory;
import org.eclipse.ditto.base.model.signals.AbstractJsonParsableRegistry;
import org.eclipse.ditto.base.model.signals.AnnotationBasedJsonParsable;
import org.eclipse.ditto.base.model.signals.JsonParsable;

public abstract class AbstractGlobalJsonParsableRegistry<T, A extends Annotation>
extends AbstractJsonParsableRegistry<T> {
    protected AbstractGlobalJsonParsableRegistry(Class<?> parsedClass, Class<A> annotationClass, AbstractAnnotationBasedJsonParsableFactory<T, A> annotationBasedJsonParsableFactory) {
        super(AbstractGlobalJsonParsableRegistry.initAnnotationBasedParseStrategies(parsedClass, annotationClass, annotationBasedJsonParsableFactory));
    }

    protected AbstractGlobalJsonParsableRegistry(Class<?> parsedClass, Class<A> annotationClass, AbstractAnnotationBasedJsonParsableFactory<T, A> annotationBasedJsonParsableFactory, Map<String, JsonParsable<T>> parseStrategies) {
        super(AbstractGlobalJsonParsableRegistry.mergeParsingStrategies(AbstractGlobalJsonParsableRegistry.initAnnotationBasedParseStrategies(parsedClass, annotationClass, annotationBasedJsonParsableFactory), parseStrategies));
    }

    private static <T> Map<String, JsonParsable<T>> mergeParsingStrategies(Map<String, JsonParsable<T>> annotationBasedStrategies, Map<String, JsonParsable<T>> otherStrategies) {
        HashMap<String, JsonParsable<T>> mergedStrategies = new HashMap<String, JsonParsable<T>>();
        mergedStrategies.putAll(annotationBasedStrategies);
        mergedStrategies.putAll(otherStrategies);
        return mergedStrategies;
    }

    private static <T, A extends Annotation> Map<String, JsonParsable<T>> initAnnotationBasedParseStrategies(Class<?> baseClass, Class<A> annotationClass, AbstractAnnotationBasedJsonParsableFactory<T, A> annotationBasedJsonParsableFactory) {
        HashMap parseRegistries = new HashMap();
        Iterable annotatedClasses = ClassIndex.getAnnotated(annotationClass);
        StreamSupport.stream(annotatedClasses.spliterator(), false).filter(baseClass::isAssignableFrom).filter(cls -> !baseClass.equals(cls)).map(cls -> cls).forEach(classToParse -> {
            Object fromJsonAnnotation = classToParse.getAnnotation(annotationClass);
            AnnotationBasedJsonParsable strategy = annotationBasedJsonParsableFactory.fromAnnotation(fromJsonAnnotation, (Class)classToParse);
            parseRegistries.put(strategy.getKey(), strategy);
        });
        return parseRegistries;
    }
}

